<?php $this->layout('layouts/main'); ?>

<section class="container py-5">
	<div class="row">
		<div class="col-md-3 order-2 order-md-1 mb-3">
			<div class="widget mb-4">
				<form action="<?php echo url('help.search') ?>" method="GET">
					<div class="input-icon mb-3">
						<span class="input-icon-addon ps-3">
							<i class="ti ti-search"></i>
						</span>
						<input name="q" class="form-control py-3 ps-6 rounded-3" type="text" placeholder="<?php e__('Search...') ?>">
					</div>
				</form>
			</div>
			<!-- Related articles-->
			<?php if (count($article["relatedArticles"]) > 0): ?>
				<div class="widget mb-4">
					<h3 class="widget-title mb-3"><?php e__('Related Articles') ?></h3>
					<ul class="d-flex flex-column gap-1">
						<?php foreach ($article["relatedArticles"] as $relatedArticle): ?>
							<li class="d-flex align-items-center">
								<i class="ti ti-book me-2"></i>
								<a class="widget-link" href="<?php echo url('help.articles.show', ['id' => $relatedArticle["id"], 'slug' => $relatedArticle["slug"]]); ?>">
									<?php echo $relatedArticle["title"]; ?>
								</a>
							</li>
						<?php endforeach ?>
					</ul>
				</div>
			<?php endif ?>
		</div>
		<div class="col-md-9 order-1 order-md-2 mb-3">
			<?php $this->insert('components/breadcrumb', ['items' => [
				[
					"url" => url('help.index'),
					"text" => t__('Help Center')
				],
				[
					"url" => url('help.topics.show', ['slug' => $article["topicSlug"]]),
					"text" => $article["topicName"]
				],
				[
					"text" => $article["title"]
				]
			]]) ?>
			<!-- Page title-->
			<h1 class="h2 mt-4 mb-3">
				<?php echo $article["title"]; ?>
			</h1>
			<div class="card">
				<div class="card-body">
					<!-- Content-->
					<div class="article-content ck-content">
						<?php echo $article["content"]; ?>
					</div>
					<div class="mt-3">
						<span class="fw-medium"><?php e__('Last Updated') ?>:</span>
						<span class="fst-italic">
							<?php echo carbon($article["updateDate"])->intlFormat(); ?>
						</span>
					</div>
					
					<!-- Rate article-->
					<div class="text-center border-top mt-4 pt-4">
						<h4 class="mb-2">
							<?php e__('Was this helpful?') ?>
						</h4>
						<div id="help-vote">
							<button type="submit" class="btn btn-outline-danger me-1" data-value="false"><?php e__('No') ?></button>
							<button type="submit" class="btn btn-success" data-value="true"><?php e__('Yes') ?></button>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<?php $this->push('scripts'); ?>
	<script>
		var helpVote = $("#help-vote");
		var helpVoteBtn = $("#help-vote button");
		
		helpVoteBtn.on("click", function() {
			var helpVoteValue = $(this).data("value");
			$.ajax({
				type: "POST",
				url: '<?php echo url("help.articles.rate", ["id" => $article["id"]]) ?>',
				data: {
					csrf_token: '<?php echo csrf_token() ?>',
					rating: helpVoteValue
				},
				success: function(result) {
					if (result.status) {
						helpVote.html('<span class="text-success">' + result.message + '<span>');
					}
					else {
						swal.fire({
							title: lang.alert_title_error,
							text: lang.alert_message_something_went_wrong,
							type: "error",
							confirmButtonColor: "#02b875",
							confirmButtonText: lang.alert_btn_ok
						});
					}
				}
			});
		});
	</script>
<?php $this->end(); ?>