<?php $this->layout('layouts/main'); ?>

<section class="bg-surface py-6 border-bottom">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-lg-6 col-md-8 text-center">
				<h1><?php e__('How can we help you?') ?></h1>
				<form action="<?php echo url('help.search') ?>" method="GET">
					<div class="input-icon mb-3">
						<span class="input-icon-addon">
							<i class="ti ti-search"></i>
						</span>
						<input name="q" class="form-control form-control-lg" type="text" placeholder="<?php e__('Search...') ?>">
					</div>
				</form>
			</div>
		</div>
	</div>
</section>

<section class="container py-6">
	<h2 class="mb-3"><?php e__('Topics') ?></h2>
	<div class="row row-gap-3">
		<?php if (count($topics) > 0): ?>
			<?php foreach ($topics as $topic): ?>
				<div class="col-lg-3 col-sm-6">
					<a class="card h-100" href="<?php echo url('help.topics.show', ['slug' => $topic["slug"]]); ?>">
						<div class="card-body text-center">
							<img class="mt-2 mb-3" src="<?php echo $topic["image"]; ?>" loading="lazy" width="64" height="64" />
							<h3 class="h3 mb-0">
								<?php echo $topic["name"]; ?>
							</h3>
							<div>
								<?php echo $topic["description"]; ?>
							</div>
						</div>
					</a>
				</div>
			<?php endforeach ?>
		<?php else: ?>
			<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No topics were found!')]); ?>
		<?php endif ?>
	</div>
</section>

<section class="container pb-6">
	<h2 class="mb-3"><?php e__('FAQ') ?></h2>
	<div class="row">
		<?php if (count($popularArticles) > 0): ?>
			<?php foreach ($popularArticles as $popularArticle): ?>
				<div class="col-md-6">
					<a href="<?php echo url('help.articles.show', ['id' => $popularArticle["id"], 'slug' => $popularArticle["slug"]]); ?>">
						<div class="card">
							<div class="card-body">
								<i class="ti ti-book me-2"></i>
								<?php echo $popularArticle["title"]; ?>
							</div>
						</div>
					</a>
				</div>
			<?php endforeach ?>
		<?php else: ?>
			<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No articles were found!')]); ?>
		<?php endif ?>
	</div>
</section>