<?php $this->layout('layouts/main'); ?>

<section class="bg-surface py-6 border-bottom">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-lg-6 col-md-8 text-center">
				<h1><?php e__('How can we help you?') ?></h1>
				<form action="<?php echo url('help.search') ?>" method="GET">
					<div class="input-icon mb-3">
						<span class="input-icon-addon">
							<i class="ti ti-search"></i>
						</span>
						<input name="q" class="form-control form-control-lg" type="text" placeholder="<?php e__('Search...') ?>">
					</div>
				</form>
			</div>
		</div>
	</div>
</section>

<section class="container py-6">
	<h2 class="mb-3">
		<?php echo $topic["name"]; ?>
	</h2>
		<?php if (count($topic["articles"]) > 0): ?>
			<div class="row">
				<?php foreach ($topic["articles"] as $article): ?>
					<div class="col-md-6">
						<a href="<?php echo url('help.articles.show', ['id' => $article["id"], 'slug' => $article["slug"]]); ?>">
							<div class="card">
								<div class="card-body">
									<i class="ti ti-book me-2"></i>
									<?php echo $article["title"]; ?>
								</div>
							</div>
						</a>
					</div>
				<?php endforeach ?>
			</div>
		<?php else: ?>
			<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No articles were found!')]); ?>
		<?php endif ?>
</section>