<?php $this->layout('layouts/main'); ?>

<section class="section home-section">
	<div class="container">
		<?php if (modules("slider")->isActive()): ?>
			<?php if (count($sliderItems) > 0): ?>
				<div class="home-slider rounded-3 mb-5">
					<div id="carousel-controls" class="carousel slide" data-bs-ride="carousel">
						<div class="carousel-inner">
							<?php foreach ($sliderItems as $i => $sliderItem): ?>
								<a href="<?php echo $sliderItem["url"]; ?>" class="carousel-item <?php _active($i == 0); ?>">
									<img class="d-block w-100 rounded-3" alt="" src="<?php echo $sliderItem['image']; ?>">
								</a>
							<?php endforeach; ?>
						</div>
						<a class="carousel-control-prev" href="#carousel-controls" role="button" data-bs-slide="prev">
							<span class="carousel-control-prev-icon" aria-hidden="true"></span>
							<span class="visually-hidden">Previous</span>
						</a>
						<a class="carousel-control-next" href="#carousel-controls" role="button" data-bs-slide="next">
							<span class="carousel-control-next-icon" aria-hidden="true"></span>
							<span class="visually-hidden">Next</span>
						</a>
					</div>
				</div>
			<?php endif; ?>
		<?php endif; ?>
		
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Blog')
					]
				]]) ?>
			</div>
		</div>
		<h2 class="page-title mt-3 mb-3"><?php e__('Blog') ?></h2>
		<div class="row">
			<div class="<?php echo (theme()->settings("sidebar") == 0) ? 'col-md-12' : 'col-md-8'; ?>">
				<?php if (count($posts) > 0): ?>
					<?php foreach ($posts as $post): ?>
						<div class="card card-hover">
							<div class="row g-0">
								<div class="col-md-5">
									<a class="d-flex h-100" href="<?php echo url('blog.posts.show', ['slug' => $post["slug"]]); ?>">
										<img class="lazyload card-img-right" data-src="<?php echo $post["image"]; ?>" src="/assets/core/images/loaders/news.png" alt="<?php echo $post["title"]; ?>">
									</a>
								</div>
								<div class="col-md-7">
									<div class="card-body">
										<a class="fs-sm mb-2" href="<?php echo url('blog.categories.show', ['slug' => $post["category"]["slug"]]); ?>">
											<?php echo $post["category"]["name"]; ?>
										</a>
										<span class="fs-sm mb-2">-</span>
										<span class="fs-sm mb-2">
											<?php echo carbon($post["creationDate"])->intlFormat(); ?>
										</span>
										<h3 class="h3 mt-2 mb-2">
											<a href="<?php echo url('blog.posts.show', ['slug' => $post["slug"]]); ?>">
												<?php echo $post["title"]; ?>
											</a>
										</h3>
										<p class="mb-3"><?php echo limit_string($post["content"], 250); ?></p>
										<div class="d-flex justify-content-end">
											<a href="<?php echo url('blog.posts.show', ['slug' => $post["slug"]]); ?>" class="btn btn-primary"><?php e__('Read More') ?></a>
										</div>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
					<div class="d-md-flex justify-content-center align-items-center pt-5 pb-2 <?php echo (theme()->settings("sidebar") == 1) ? 'mb-4' : null; ?>">
						<?php $this->insert('components/pagination', [
							'page' => $page,
							'pageCount' => $pageCount,
						]) ?>
					</div>
				<?php else : ?>
					<div class="col-md-12">
						<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No posts were found!')]); ?>
					</div>
				<?php endif; ?>
			</div>
			<?php if (theme()->settings("sidebar") == 1): ?>
				<div class="col-md-4">
					<?php if (theme()->settings("discordWidget") == 1): ?>
						<?php if (theme()->settings("discordServerID") != '0'): ?>
							<div class="mb-3">
								<iframe class="rounded-3 lazyload" data-src="https://discordapp.com/widget?id=<?php echo theme()->settings("discordServerID"); ?>&theme=<?php echo $this->e($theme_mode); ?>" width="100%" height="500" allowtransparency="true" frameborder="0"></iframe>
							</div>
						<?php endif; ?>
					<?php endif; ?>
					
					<?php if (theme()->settings("topDonorsAllTimeWidget") == 1): ?>
						<div class="card">
							<div class="card-header justify-content-between">
								<h2 class="card-title fs-100"><?php e__('Top Donors') ?></h2>
								<span class="small">(<?php e__('All Time') ?>)</span>
							</div>
							<?php if (count($topDonorsAllTime) > 0): ?>
								<div class="card-body p-0">
									<div class="table-responsive">
										<table class="table table-hover">
											<thead>
											<tr>
												<th><?php e__('Username') ?></th>
												<th class="text-end"><?php e__('Total') ?></th>
											</tr>
											</thead>
											<tbody>
											<?php foreach ($topDonorsAllTime as $donor): ?>
												<tr>
													<td>
														<a href="<?php echo url('members.show', ['id' => $donor["accountID"]]) ?>">
															<?php $this->insert("components/avatar", [
																'avatar' => $donor["avatar"],
																'username' => $donor["displayName"],
																'class' => 'avatar avatar-xs me-2'
															]) ?>
															
															<?php echo $donor["displayName"]; ?>
														</a>
													</td>
													<td class="text-end"><?php echo money()->real($donor["total"]); ?></td>
												</tr>
											<?php endforeach; ?>
											</tbody>
										</table>
									</div>
								</div>
							<?php else: ?>
								<div class="card-body">
									<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?>
								</div>
							<?php endif; ?>
						</div>
					<?php endif; ?>
					
					<?php if (theme()->settings("topDonorsCurrentMonthWidget") == 1): ?>
						<div class="card">
							<div class="card-header justify-content-between">
								<h2 class="card-title fs-100"><?php e__('Top Donors') ?></h2>
								<span class="small">(<?php e__('This Month') ?>)</span>
							</div>
							<?php if (count($topDonorsMonth) > 0): ?>
								<div class="card-body p-0">
									<div class="table-responsive">
										<table class="table table-hover">
											<thead>
											<tr>
												<th><?php e__('Username') ?></th>
												<th class="text-end"><?php e__('Total') ?></th>
											</tr>
											</thead>
											<tbody>
											<?php foreach ($topDonorsMonth as $donor): ?>
												<tr>
													<td>
														<a href="<?php echo url('members.show', ['id' => $donor["accountID"]]) ?>">
															<?php $this->insert("components/avatar", [
																'avatar' => $donor["avatar"],
																'username' => $donor["displayName"],
																'class' => 'avatar avatar-xs me-2'
															]) ?>
															
															<?php echo $donor["displayName"]; ?>
														</a>
													</td>
													<td class="text-end"><?php echo money()->real($donor["total"]); ?></td>
												</tr>
											<?php endforeach; ?>
											</tbody>
										</table>
									</div>
								</div>
							<?php else: ?>
								<div class="card-body">
									<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?>
								</div>
							<?php endif; ?>
						</div>
					<?php endif; ?>
					
					<?php if (theme()->settings("recentDonationsWidget") == 1): ?>
						<div class="card">
							<div class="card-header">
								<h2 class="card-title fs-100"><?php e__('Recent Donations') ?></h2>
							</div>
							<?php if (count($recentDonations) > 0): ?>
								<div class="card-body p-0">
									<div class="table-responsive">
										<table class="table table-hover">
											<thead>
											<tr>
												<th><?php e__('Username') ?></th>
												<th class="text-end"><?php e__('Amount') ?></th>
											</tr>
											</thead>
											<tbody>
											<?php foreach ($recentDonations as $donation): ?>
												<tr>
													<td>
														<a href="<?php echo url('members.show', ['id' => $donation["accountID"]]) ?>">
															<?php $this->insert("components/avatar", [
																'avatar' => $donation["avatar"],
																'username' => $donation["displayName"],
																'class' => 'avatar avatar-xs me-2'
															]) ?>
															
															<?php echo $donation["displayName"]; ?>
														</a>
													</td>
													<td class="text-end"><?php echo money()->real($donation["total"]); ?></td>
												</tr>
											<?php endforeach; ?>
											</tbody>
										</table>
									</div>
								</div>
							<?php else : ?>
								<div class="card-body">
									<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?>
								</div>
							<?php endif; ?>
						</div>
					<?php endif; ?>
					
					<?php if (theme()->settings("recentPurchasesWidget") == 1): ?>
						<div class="card">
							<div class="card-header">
								<h2 class="card-title fs-100"><?php e__('Recent Purchases') ?></h2>
							</div>
							<?php if (count($recentPurchases) > 0): ?>
								<div class="card-body p-0">
									<div class="table-responsive">
										<table class="table table-hover">
											<thead>
											<tr>
												<th><?php e__('Username') ?></th>
												<th class="text-center"><?php e__('Category') ?></th>
												<th class="text-center"><?php e__('Product') ?></th>
											</tr>
											</thead>
											<tbody>
											<?php foreach ($recentPurchases as $purchase): ?>
												<tr>
													<td>
														<a href="<?php echo url('members.show', ['id' => $purchase["accountID"]]) ?>">
															<?php $this->insert("components/avatar", [
																'avatar' => $purchase["avatar"],
																'username' => $purchase["displayName"],
																'class' => 'avatar avatar-xs me-2'
															]) ?>
															
															<?php echo $purchase["displayName"]; ?>
														</a>
													</td>
													<td class="text-center"><?php echo $purchase["categoryName"]; ?></td>
													<td class="text-center"><?php echo $purchase["productName"]; ?></td>
												</tr>
											<?php endforeach; ?>
											</tbody>
										</table>
									</div>
								</div>
							<?php else : ?>
								<div class="card-body">
									<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?>
								</div>
							<?php endif; ?>
						</div>
					<?php endif; ?>
				</div>
			<?php endif; ?>
		</div>
	</div>
</section>