<?php $this->layout('layouts/main'); ?>

<section class="section leaderboards-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('leaderboards.index'),
						"text" => t__('Leaderboards')
					],
					[
						"text" => $leaderboard["serverName"]
					]
				]]) ?>
			</div>
			<div class="col-md-3">
				<?php if (count($servers) > 0): ?>
					<div class="card">
						<div class="card-header">
							<h2 class="card-title"><?php e__('Leaderboards') ?></h2>
						</div>
						<div class="card-body p-0">
							<ul class="list-group list-group-flush">
								<?php foreach ($servers as $server): ?>
									<li class="list-group-item <?php _active($server["serverSlug"] == $leaderboard["serverSlug"]); ?>">
										<a href="<?php echo url('leaderboards.show', ['slug' => $server["serverSlug"]]); ?>">
											<?php echo $server["serverName"]; ?>
										</a>
									</li>
								<?php endforeach; ?>
							</ul>
						</div>
					</div>
				<?php else: ?>
					<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('Server not found!')]); ?>
				<?php endif; ?>
			</div>
			
			<div class="col-md-9">
				<?php if (count($leaderboard["data"]) > 0): ?>
					<div id="searchAlert" style="display: none;"></div>
					<div class="card">
						<div class="card-header">
							<h2 class="card-title"><?php e__('Leaderboard') ?></h2>
						</div>
						<div id="loader" class="card-body p-0">
							<form method="get">
								<div id="searchBox" class="input-group input-icon">
									<div class="input-icon-addon">
										<i class="ti ti-search"></i>
									</div>
									<input type="search" name="search" id="inputSearch" class="form-control border-0" placeholder="<?php e__('Search player...') ?>" aria-label="<?php e__('Search player...') ?>" aria-describedby="ariaSearch" value="<?php echo $this->e(input('search')); ?>">
									<div class="input-group-append">
										<?php if (input('search')): ?>
											<a href="<?php echo url('leaderboards.show', ['slug' => $leaderboard["slug"]]) ?>" id="cancelSearch" class="text-danger me-2"><i class="fa fa-times"></i></a>
										<?php endif; ?>
										<button type="submit" id="ariaSearch" class="btn btn-primary border-0" style="border-radius: 0 !important;"><?php e__('Search') ?></button>
									</div>
								</div>
							</form>
							<div class="table-responsive">
								<table class="table table-hover">
									<thead>
									<tr>
										<th class="text-center" style="width: 40px;"><?php e__('Rank') ?></th>
										<th><?php e__('Username') ?></th>
										<?php foreach ($leaderboard["tableTitles"] as $readTableTitles): ?>
											<th class="text-center"><?php echo $readTableTitles; ?></th>
										<?php endforeach; ?>
									</tr>
									</thead>
									<tbody id="leaderboards">
									<?php foreach ($leaderboard["data"] as $readLeaderboard): ?>
										<tr class="<?php _active(auth()->check() && ($readLeaderboard[$leaderboard["usernameColumn"]] == auth()->user()->displayName())); ?>">
											<td class="text-center" style="width: 40px;">
												<?php if ($readLeaderboard["rank"] == 1): ?>
													<img src="<?php echo $this->asset('/img/medal-1.svg'); ?>" width="25">
												<?php elseif ($readLeaderboard["rank"] == 2): ?>
													<img src="<?php echo $this->asset('/img/medal-2.svg'); ?>" width="25">
												<?php elseif ($readLeaderboard["rank"] == 3): ?>
													<img src="<?php echo $this->asset('/img/medal-3.svg'); ?>" width="25">
												<?php else: ?>
													<?php echo $readLeaderboard["rank"]; ?>
												<?php endif; ?>
											</td>
											<td>
												<?php if ($game_type == "minecraft"): ?>
													<img src="http://cravatar.eu/avatar/<?php echo $readLeaderboard[$leaderboard["usernameColumn"]] ?>/20.png" class="rounded-2 me-1">
												<?php endif; ?>
												<?php echo $readLeaderboard[$leaderboard["usernameColumn"]]; ?>
											</td>
											<?php foreach ($leaderboard["tableData"] as $readTableData): ?>
												<td class="text-center"><?php echo $readLeaderboard[$readTableData]; ?></td>
											<?php endforeach; ?>
										</tr>
									<?php endforeach; ?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				<?php else: ?>
					<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No ranking data found for this server!')]); ?>
				<?php endif; ?>
			</div>
		</div>
	</div>
</section>
