<?php $this->layout('layouts/main'); ?>

<section class="section profile-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Members')
					],
					[
						"text" => $member["displayName"]
					]
				]]) ?>
			</div>
			<div class="col-lg-4 mb-4 mb-lg-0">
				<div class="card">
					<div class="card-body p-4 text-center">
						<?php $this->insert('components/avatar', [
							'avatar' => $member["avatar"],
							'username' => $member["displayName"],
							'class' => 'avatar avatar-xl mb-3 rounded'
						]); ?>
						<h3 class="m-0 mb-2 username__<?php echo $member["primaryRole"]["slug"] ?>">
							<?php echo $member["displayName"]; ?>
						</h3>
						<div>
							<?php foreach ($member["roles"] as $role): ?>
								<span class="role__default role__<?php echo $role["slug"]; ?>">
									<?php echo $role["name"] ?>
								</span>
							<?php endforeach; ?>
						</div>
					</div>
					<div>
						<h3 class="d-block h5 mb-0 px-4 py-3 text-uppercase bg-body">
							<?php e__('Details') ?>
						</h3>
						<div class="d-flex flex-column gap-3 py-3">
							<span class="d-flex align-items-center px-4">
								<i class="ti ti-calendar opacity-60 me-2"></i>
								<?php e__('Last Seen') ?>:
								<span class="text-muted ms-auto">
									<?php echo $member["lastSeen"] == null ? '-' : carbon($member["lastSeen"])->intlFormat(); ?>
								</span>
							</span>
							<span class="d-flex align-items-center px-4">
								<i class="ti ti-calendar opacity-60 me-2"></i>
								<?php e__('Reg. Date') ?>:
								<span class="text-muted ms-auto">
									<?php echo $member["creationDate"] == null ? '-' : carbon($member["creationDate"])->intlFormat(); ?>
								</span>
							</span>
							<?php foreach ($member["customFields"] as $customField): ?>
								<span class="d-flex align-items-center px-4">
									<i class="ti ti-info-circle opacity-60 me-2"></i>
									<?php echo $customField["name"] ?>:
									<span class="text-muted ms-auto">
										<?php echo $customField["value"]; ?>
									</span>
								</span>
							<?php endforeach; ?>
						</div>
					</div>
					<?php if (count($member["bans"]) > 0): ?>
						<div>
							<h3 class="d-block h5 mb-0 px-4 py-3 text-uppercase bg-body">
								<?php e__('Bans') ?>
							</h3>
							<div class="d-flex flex-column gap-3 py-3">
								<?php foreach ($member["bans"] as $ban): ?>
									<span class="d-flex align-items-center px-4">
										<i class="ti ti-ban opacity-60 me-2"></i>
										<?php if ($ban["categoryID"] == 1): ?>
											<?php e__('Ban (Website)') ?>
										<?php endif; ?>
										<?php if ($ban["categoryID"] == 2): ?>
											<?php e__('Ban (Support)') ?>
										<?php endif; ?>
										<?php if ($ban["categoryID"] == 3): ?>
											<?php e__('Ban (Comment)') ?>
										<?php endif; ?>
										<span class="text-muted ms-auto">
											<?php echo ($ban["expiryDate"] == '1000-01-01 00:00:00') ? t__('Perma ban') : carbon($ban["expiryDate"])->intlFormat(); ?>
										</span>
									</span>
								<?php endforeach; ?>
							</div>
						</div>
					<?php endif; ?>
				</div>
			</div>
			
			<div class="col-md-8">
				<?php if (count($leaderboards) > 0): ?>
					<div class="card">
						<div class="card-body p-0">
							<nav>
								<div class="nav nav-tabs nav-fill">
									<?php foreach ($leaderboards as $leaderboardItem): ?>
										<a class="nav-item nav-link <?php _active($leaderboard !== null && $leaderboard["serverSlug"] == $leaderboardItem["serverSlug"]); ?>" href="?leaderboard=<?php echo $leaderboardItem["serverSlug"]; ?>">
											<?php echo $leaderboardItem["serverName"]; ?>
										</a>
									<?php endforeach; ?>
								</div>
							</nav>
							<div class="tab-content" id="nav-tabContent">
								<?php if ($leaderboard !== null): ?>
									<div class="tab-pane fade show active">
										<?php if ($leaderboard["userData"]): ?>
											<div class="table-responsive">
												<table class="table table-hover">
													<thead>
													<tr>
														<th><?php e__('Username') ?></th>
														<?php foreach ($leaderboard["tableTitles"] as $tableTitle): ?>
															<th class="text-center"><?php echo $tableTitle; ?></th>
														<?php endforeach; ?>
													</tr>
													</thead>
													<tbody id="leaderboards">
													<tr>
														<td>
															<?php echo $leaderboard["userData"][$leaderboard["usernameColumn"]]; ?>
														</td>
														<?php foreach ($leaderboard["tableColumns"] as $tableColumn): ?>
															<td class="text-center"><?php echo $leaderboard["userData"][$tableColumn]; ?></td>
														<?php endforeach; ?>
													</tr>
													</tbody>
												</table>
											</div>
										<?php else: ?>
											<div class="p-4"><?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]); ?></div>
										<?php endif; ?>
									</div>
								<?php else: ?>
									<div class="tab-pane fade show active">
										<div class="py-4 px-4 d-flex justify-content-center align-items-center gap-2">
											<i class="ti ti-eye"></i>
											<?php e__('Please select a leaderboard to view.') ?>
										</div>
									</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
				<?php else: ?>
				  <?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data found!')]) ?>
				<?php endif; ?>
			</div>
		</div>
	</div>
</section>