<?php $this->layout('layouts/main'); ?>

<section class="section support-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Orders')
					]
				]]) ?>
			</div>
			<div class="col-md-8">
				<div class="card">
					<div class="card-header">
						<h2 class="card-title"><?php echo t__('Orders') . " #" . $order["id"] ?></h2>
					</div>
					<div class="card-body p-0">
						<div class="table-responsive">
							<table class="table table-hover">
								<thead>
								<tr>
									<th><?php e__('Product') ?></th>
									<th><?php e__('Quantity') ?></th>
									<th><?php e__('Total') ?></th>
								</tr>
								</thead>
								<tbody>
								<?php if ($order["type"] == 1): ?>
									<?php foreach ($order["products"] as $product): ?>
										<tr>
											<td>
												<?php echo $product["name"]; ?>
												<?php if (count($product["variables"]) > 0): ?>
												  <div class="mt-1">
													  <?php foreach ($product["variables"] as $variable): ?>
														  <div class="small opacity-75">
															  <?php echo $variable["name"] . ": " . $variable["value"]; ?>
														  </div>
													  <?php endforeach; ?>
												  </div>
												<?php endif; ?>
											</td>
											<td><?php echo $product["quantity"]; ?></td>
											<td><?php echo money()->format($product["unitPrice"] * $product["quantity"], false); ?></td>
										</tr>
									<?php endforeach; ?>
								<?php elseif ($order["type"] == 2): ?>
									<tr>
										<td><?php echo money()->credits($order["product"]["amount"]); ?></td>
										<td>1</td>
										<td><?php echo money()->real($order["total"], false); ?></td>
									</tr>
								<?php elseif ($order["type"] == 3): ?>
									<?php foreach ($order["products"] as $product): ?>
										<tr>
											<td><?php echo $product["name"]; ?></td>
											<td><?php echo money()->credits($product["amount"]); ?></td>
											<td><?php echo money()->real($order["total"], false) ?></td>
										</tr>
									<?php endforeach; ?>
								<?php endif; ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-4">
				<div class="card">
					<div class="card-header">
						<h2 class="card-title fs-100"><?php e__('Order Summary') ?></h2>
					</div>
					<div class="card-body d-flex flex-column gap-2">
						<?php if ($order["coupon"] != null): ?>
							<div class="row mb-2">
								<div class="col-md-12">
									<label class="small fw-bold mb-1"><?php e__('Coupon') ?>:</label>
									<div class="input-group">
										<input type="text" class="form-control" name="coupon" disabled readonly value="<?php echo $order["coupon"]; ?>">
									</div>
								</div>
							</div>
						<?php endif; ?>
						<?php if ($order["cashback"] > 0): ?>
							<div class="row">
								<div class="col">
									<span class="fw-bold"><?php e__('Cashback') ?>:</span>
								</div>
								<div class="col-auto text-end">
									<span class="text-success">
										+<?php echo money()->format($order["cashback"], false); ?>
									</span>
								</div>
							</div>
						<?php endif; ?>
						<?php if ($order["discount"] != 0 || $order["tax"] != 0 || (modules('store')->settings('isCreditRequiredOnPurchase') == 0 && $order["credit"] > 0)): ?>
							<div class="row">
								<div class="col">
									<span class="fw-bold"><?php e__('Subtotal') ?>:</span>
								</div>
								<div class="col-auto text-end">
									<span>
										<?php if ($order["type"] == 1): ?>
										  <?php echo money()->format($order["subtotal"], false); ?>
										<?php else: ?>
										  <?php echo money()->real($order["subtotal"], false); ?>
										<?php endif; ?>
									</span>
								</div>
							</div>
						<?php endif; ?>
						<?php if ($order["tax"] != 0): ?>
							<div class="row">
								<div class="col">
									<span class="fw-bold"><?php e__('Tax') ?>:</span>
								</div>
								<div class="col-auto text-end">
									<span class="text-danger">
										<?php echo money()->real($order["tax"], false); ?>
									</span>
								</div>
							</div>
						<?php endif; ?>
						<?php if ($order["discount"] != 0): ?>
							<div class="row">
								<div class="col">
									<span class="fw-bold"><?php e__('Discount') ?>:</span>
								</div>
								<div class="col-auto text-end">
									<span class="text-danger">
										<?php if ($order["type"] == 1): ?>
											-<?php echo money()->format($order["discount"], false); ?>
										<?php else: ?>
											-<?php echo money()->real($order["discount"], false); ?>
										<?php endif; ?>
									</span>
								</div>
							</div>
						<?php endif; ?>
						<?php if ($order["credit"] > 0 && (modules('store')->settings('isCreditRequiredOnPurchase') == 0 || $order["paymentAPI"] != "credit")): ?>
							<div class="row">
								<div class="col">
									<span class="fw-bold"><?php e__('Credit') ?>:</span>
								</div>
								<div class="col-auto text-end">
									<span class="text-danger">
										-<?php echo money()->format($order["credit"], false); ?>
									</span>
								</div>
							</div>
						<?php endif; ?>
						<div class="row">
							<div class="col">
								<span class="fw-bold"><?php e__('Total') ?>:</span>
							</div>
							<div class="col-auto text-end">
								<span class="text-success">
									<?php if ($order["type"] == 1): ?>
										<?php if ($order["paymentAPI"] == 'credit'): ?>
											<?php echo money()->format($order["credit"], false); ?>
										<?php else: ?>
											<?php echo money()->format($order["total"]-$order["credit"], false); ?>
										<?php endif; ?>
									<?php else: ?>
										<?php echo money()->real($order["earnings"], false); ?>
									<?php endif; ?>
								</span>
							</div>
						</div>
						<div class="row">
							<div class="col">
								<span class="fw-bold"><?php e__('Date') ?>:</span>
							</div>
							<div class="col-auto text-end">
								<?php echo carbon($order["creationDate"])->intlFormat(); ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
