<?php $this->layout('layouts/main'); ?>

<section class="section page-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('punishments.index'),
						"text" => t__('Punishments')
					],
					[
						"text" => t__('Mutes')
					]
				]]) ?>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<?php if (count($mutes) > 0): ?>
					<div class="card">
						<div class="card-header">
							<h2 class="card-title"><?php e__('Mutes') ?></h2>
						</div>
						<div class="card-body p-0">
							<form method="get">
								<div id="searchBox" class="input-group input-icon">
									<div class="input-icon-addon">
										<i class="ti ti-search"></i>
									</div>
									<input type="search" name="search" id="inputSearch" class="form-control border-0" placeholder="<?php e__('Search player...') ?>" aria-label="<?php e__('Search player...') ?>" aria-describedby="ariaSearch" value="<?php echo $this->e(input('search')); ?>">
									<div class="input-group-append">
										<?php if (input('search')): ?>
											<a href="<?php echo url('punishments.mutes') ?>" id="cancelSearch" class="text-danger me-2"><i class="fa fa-times"></i></a>
										<?php endif; ?>
										<button type="submit" id="ariaSearch" class="btn btn-primary border-0" style="border-radius: 0 !important;"><?php e__('Search') ?></button>
									</div>
								</div>
							</form>
							<div class="table-responsive">
								<table class="table table-hover">
									<thead>
									<tr>
										<th><?php e__('Player') ?></th>
										<th><?php e__('Muted by') ?></th>
										<th style="word-wrap: break-word; max-width: 250px"><?php e__('Reason') ?></th>
										<th><?php e__('Date') ?></th>
										<th><?php e__('Expires') ?></th>
									</tr>
									</thead>
									<tbody>
									<?php foreach ($mutes as $mute): ?>
										<tr>
											<td>
												<?php if ($game_type == "minecraft"): ?>
													<img src="http://cravatar.eu/avatar/<?php echo $mute["banned_name"] ?>/24.png" class="rounded-2 me-1">
												<?php endif; ?>
												<?php echo $mute["banned_name"]; ?>
											</td>
											<td>
												<?php if ($game_type == "minecraft"): ?>
													<img src="http://cravatar.eu/avatar/<?php echo $mute["banned_by_name"] ?>/24.png" class="rounded-2 me-1">
												<?php endif; ?>
												<?php echo $mute["banned_by_name"]; ?>
											</td>
											<td style="word-wrap: break-word; max-width: 250px">
												<?php echo $mute["reason"]; ?>
											</td>
											<td>
												<?php echo carbon(date('Y-m-d H:i:s', $mute["time"]/1000))->intlFormat(); ?>
											</td>
											<td>
												<?php if ($mute["until"] <= 0): ?>
													<?php e__('Permanently') ?>
												<?php else: ?>
													<?php echo carbon(date('Y-m-d H:i:s', $mute["until"]/1000))->intlFormat(); ?>
													<?php if (time() * 1000 > $mute["until"] && isset($mute["removed_by_name"]) && $mute["removed_by_name"] == null): ?>
														(<?php e__('Expired') ?>)
													<?php endif; ?>
												<?php endif; ?>
												<?php if (isset($mute["removed_by_name"]) && $mute["removed_by_name"] != null): ?>
													(<?php e__('Unmuted by %user%', ['%user%' => $mute["removed_by_name"]]) ?>)
												<?php endif; ?>
											</td>
										</tr>
									<?php endforeach; ?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
					
					<div class="col-md-12 d-flex justify-content-center mt-4">
						<?php $this->insert('components/pagination', [
							'page' => $page,
							'pageCount' => $pageCount,
						]) ?>
					</div>
				<?php else: ?>
					<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data were found!')]); ?>
				<?php endif; ?>
			</div>
		</div>
	</div>
</section>
