<?php $this->layout('layouts/main'); ?>

<section class="section page-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('punishments.index'),
						"text" => t__('Punishments')
					],
					[
						"text" => t__('Warnings')
					]
				]]) ?>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<?php if (count($warnings) > 0): ?>
					<div class="card">
						<div class="card-header">
							<h2 class="card-title"><?php e__('Warnings') ?></h2>
						</div>
						<div class="card-body p-0">
							<form method="get">
								<div id="searchBox" class="input-group input-icon">
									<div class="input-icon-addon">
										<i class="ti ti-search"></i>
									</div>
									<input type="search" name="search" id="inputSearch" class="form-control border-0" placeholder="<?php e__('Search player...') ?>" aria-label="<?php e__('Search player...') ?>" aria-describedby="ariaSearch" value="<?php echo $this->e(input('search')); ?>">
									<div class="input-group-append">
										<?php if (input('search')): ?>
											<a href="<?php echo url('punishments.warnings') ?>" id="cancelSearch" class="text-danger me-2"><i class="fa fa-times"></i></a>
										<?php endif; ?>
										<button type="submit" id="ariaSearch" class="btn btn-primary border-0" style="border-radius: 0 !important;"><?php e__('Search') ?></button>
									</div>
								</div>
							</form>
							<div class="table-responsive">
								<table class="table table-hover">
									<thead>
									<tr>
										<th><?php e__('Player') ?></th>
										<th><?php e__('Warned by') ?></th>
										<th style="word-wrap: break-word; max-width: 250px"><?php e__('Reason') ?></th>
										<th><?php e__('Date') ?></th>
									</tr>
									</thead>
									<tbody>
									<?php foreach ($warnings as $warning): ?>
										<tr>
											<td>
												<?php if ($game_type == "minecraft"): ?>
													<img src="http://cravatar.eu/avatar/<?php echo $warning["banned_name"] ?>/24.png" class="rounded-2 me-1">
												<?php endif; ?>
												<?php echo $warning["banned_name"]; ?>
											</td>
											<td>
												<?php if ($game_type == "minecraft"): ?>
													<img src="http://cravatar.eu/avatar/<?php echo $warning["banned_by_name"] ?>/24.png" class="rounded-2 me-1">
												<?php endif; ?>
												<?php echo $warning["banned_by_name"]; ?>
											</td>
											<td style="word-wrap: break-word; max-width: 250px">
												<?php echo $warning["reason"]; ?>
											</td>
											<td>
												<?php echo carbon(date('Y-m-d H:i:s', $warning["time"]/1000))->intlFormat(); ?>
											</td>
										</tr>
									<?php endforeach; ?>
									</tbody>
								</table>
							</div>
						</div>
					</div>
					
					<div class="col-md-12 d-flex justify-content-center mt-4">
						<?php $this->insert('components/pagination', [
							'page' => $page,
							'pageCount' => $pageCount,
						]) ?>
					</div>
				<?php else: ?>
					<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No data were found!')]); ?>
				<?php endif; ?>
			</div>
		</div>
	</div>
</section>
