<?php $this->layout('layouts/main'); ?>

<section class="section page-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Staff')
					]
				]]) ?>
			</div>
		</div>
		<div class="row mt-2">
			<div class="col-md-12">
				<?php foreach ($roles as $role => $staffs): ?>
					<h4 class="h3 mb-2"><?php echo $role ?></h4>
					<div class="row mb-4">
						<?php foreach ($staffs as $staff): ?>
							<div class="col-md-3">
								<div class="card">
									<a href="<?php echo url('members.show', ['id' => $staff["id"]]); ?>" class="card-body no-underline">
										<div class="d-flex align-items-center gap-3">
											<?php $this->insert('components/avatar', [
												'avatar' => $staff["avatar"],
												'username' => $staff["displayName"],
												'class' => 'avatar avatar-lg'
											]); ?>
											<div class="lh-1">
												<span class="h4 mb-0"><?php echo $staff["displayName"]; ?></span>
												<div class="text-muted small"><?php echo $role; ?></div>
											</div>
										</div>
									</a>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
	</div>
</section>
