<?php $this->layout('layouts/main') ?>
<section class="section page-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('store.index'),
						"text" => t__("Store")
					], [
						"url" => url('store.products.show', ['id' => $product["id"]]),
						"text" => $product["name"]
					],
					[
						"text" => t__('Add to Cart')
					]
				]]) ?>
			</div>
			<div class="col-md-12">
				<?php _message(); ?>
				<div class="card">
					<div class="card-header">
						<h2 class="card-title"><?php e__('Add to Cart'); ?></h2>
					</div>
					<div class="card-body">
						<form data-toggle="form-submit-with-loader" action="<?php echo url('cart.items.add') ?>" method="post">
							<?php _csrf(); ?>
							<input type="hidden" name="productID" value="<?php echo $product["id"] ?>">
							<input type="hidden" name="quantity" value="<?php echo $quantity ?>">
							
							<?php foreach ($product["variables"] as $variable): ?>
								<div class="mb-3">
									<label for="variable_<?php echo $variable["id"] ?>" class="form-label">
										<?php echo $variable["name"] ?>:
									</label>
									<?php if ($variable["type"] == "dropdown"): ?>
										<select name="variable_<?php echo $variable["id"] ?>" id="variable_<?php echo $variable["id"] ?>" class="form-control" required>
											<?php if ($variable["description"]): ?>
												<option value="">
													<?php echo $variable["description"]; ?>
												</option>
											<?php endif; ?>
											<?php foreach ($variable["options"] as $option): ?>
												<option value="<?php echo $option["value"] ?>">
													<?php echo $option["name"] ?>
													<?php if ($option["price"] != 0): ?>
	                          (+<?php echo money()->format($option["price"]) ?>)
													<?php endif; ?>
												</option>
											<?php endforeach; ?>
										</select>
									<?php else: ?>
										<input type="text" class="form-control" id="variable_<?php echo $variable["id"] ?>" name="variable_<?php echo $variable["id"] ?>" placeholder="<?php echo $variable["description"]; ?>" value="<?php echo old('variable_' . $variable["id"]) ?>" required>
									<?php endif; ?>
								</div>
							<?php endforeach; ?>
							
							<div class="d-flex justify-content-end">
								<button type="submit" class="btn btn-primary">
									<?php e__('Continue') ?>
								</button>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>