<?php $this->layout('layouts/main'); ?>

<?php $this->push('head'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/alpinejs/3.14.8/cdn.min.js" defer></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/1.7.4/axios.min.js"></script>
<?php $this->end(); ?>

<?php $this->push('scripts'); ?>
<script>
	function cart() {
		return {
			axiosClient: null,
			featuredProductsStatus: <?php echo modules('store')->settings('featuredProducts') ? "true" : "false"; ?>,
			featuredProductsIsLoading: true,
			featuredProducts: [],
			isLoading: true,
			couponIsLoading: false,
			coupon: null,
			couponModel: null,
			couponAlertStatus: false,
			couponAlert: null,
      creatorCodeIsLoading: false,
      creatorCode: null,
      creatorCodeModel: null,
      creatorCodeAlertStatus: false,
      creatorCodeAlert: null,
			total: null,
			total_raw: null,
			subtotal: null,
			subtotal_raw: null,
			discount: null,
			discount_raw: null,
			cashback: null,
			cashback_raw: null,
			tax: null,
			tax_raw: null,
			items: [],
			init() {
				// Axios
				this.axiosClient = axios.create({
					headers: {
						'X-CSRF-TOKEN': '<?php echo csrf_token(); ?>'
					}
				});
				
				this.fetchItems();
				if (this.featuredProductsStatus) {
					this.fetchFeaturedProducts();
				}
			},
			setData($data) {
				this.items = $data.items.map(item => {
					item.is_quantity_loading = false;
					item.is_delete_loading = false;
					item.quantityModel = item.quantity;
					
					return item;
				})
				this.coupon = ($data.coupon != null) ? $data.coupon.code : null;
				this.couponModel = this.coupon;
        this.creatorCode = ($data.creator_code != null) ? $data.creator_code.code : null;
        this.creatorCodeModel = this.creatorCode;
				this.total = $data.total;
				this.total_raw = $data.total_raw;
				this.subtotal = $data.subtotal;
				this.subtotal_raw = $data.subtotal_raw;
				this.discount = $data.discount;
				this.discount_raw = $data.discount_raw;
				this.cashback = $data.cashback;
				this.cashback_raw = $data.cashback_raw;
				this.tax = $data.tax;
				this.tax_raw = $data.tax_raw;
			},
			fetchItems() {
				this.isLoading = true;
				this.axiosClient.get("<?php echo url('cart.items.index') ?>")
					.then(response => {
						this.setData(response.data);
						this.isLoading = false;
					})
					.catch(error => {
						console.log(error);
					});
			},
			applyCoupon() {
				this.couponIsLoading = true;
				this.axiosClient.post("<?php echo url('cart.coupons.apply') ?>", {
					coupon: this.couponModel
				})
					.then(response => {
						if (response.data.status === true) {
							this.setData(response.data);
							this.couponAlertStatus = true;
							this.couponAlert = "<?php e__("Coupon applied successfully!") ?>";
						} else {
							this.couponAlertStatus = false;
							this.couponAlert = response.data.message;
						}
						this.couponIsLoading = false;
					})
					.catch(error => {
						console.log(error);
					});
			},
			removeCoupon() {
				this.couponIsLoading = true;
				this.axiosClient.post("<?php echo url('cart.coupons.remove') ?>", {
					coupon: this.couponModel
				})
					.then(response => {
						if (response.data.status === true) {
							this.setData(response.data);
							this.couponAlertStatus = true;
							this.couponAlert = null;
						} else {
							this.couponAlertStatus = false;
							this.couponAlert = response.data.message;
						}
						this.couponIsLoading = false;
					})
					.catch(error => {
						console.log(error);
					});
			},
      applyCreatorCode() {
          this.creatorCodeIsLoading = true;
          this.axiosClient.post("<?php echo url('cart.creator-codes.apply') ?>", {
              creatorCode: this.creatorCodeModel
          })
              .then(response => {
                  if (response.data.status === true) {
                      this.setData(response.data);
                      this.creatorCodeAlertStatus = true;
                      this.creatorCodeAlert = "<?php e__("Creator code applied successfully!") ?>";
                  } else {
                      this.creatorCodeAlertStatus = false;
                      this.creatorCodeAlert = response.data.message;
                  }
                  this.creatorCodeIsLoading = false;
              })
              .catch(error => {
                  console.log(error);
              });
      },
      removeCreatorCode() {
          this.creatorCodeIsLoading = true;
          this.axiosClient.post("<?php echo url('cart.creator-codes.remove') ?>", {
              creatorCode: this.creatorCodeModel
          })
              .then(response => {
                  if (response.data.status === true) {
                      this.setData(response.data);
                      this.creatorCodeAlertStatus = true;
                      this.creatorCodeAlert = null;
                  } else {
                      this.creatorCodeAlertStatus = false;
                      this.creatorCodeAlert = response.data.message;
                  }
                  this.creatorCodeIsLoading = false;
              })
              .catch(error => {
                  console.log(error);
              });
      },
			addItem($id) {
				this.axiosClient.post("<?php echo url('cart.items.add') ?>", {
					productID: $id,
					quantity: 1
				})
					.then(response => {
						if (response.data.status) {
							this.setData(response.data);
						} else {
							if (response.data.redirect) {
								window.location.href = response.data.redirect;
							} else {
								swal.fire({
									title: lang.alert_title_error,
									html: response.data.message,
									type: "error",
									allowOutsideClick: false,
									showConfirmButton: true
								});
							}
						}
					})
					.catch(error => {
						console.log(error);
					});
			},
			deleteItem($id) {
				const $item = this.items.find(item => item.id === $id);
				$item.is_delete_loading = true;
				
				this.axiosClient.post("<?php echo url('cart.items.delete') ?>", {
					id: $id
				})
					.then(response => {
						if (response.data.status) {
							this.setData(response.data);
						} else {
							swal.fire({
								title: lang.alert_title_error,
								html: response.data.message,
								type: "error",
								allowOutsideClick: false,
								showConfirmButton: true
							});
						}
					})
					.catch(error => {
						console.log(error);
					});
			},
			updateQuantity($id, $quantity) {
				const $item = this.items.find(item => item.id === $id);
				$item.is_quantity_loading = true;
				
				this.axiosClient.post("<?php echo url('cart.items.update-quantity') ?>", {
					id: $id,
					quantity: $quantity
				})
					.then(response => {
						if (response.data.status) {
							this.setData(response.data);
						} else {
							swal.fire({
								title: lang.alert_title_error,
								html: response.data.message,
								type: "error",
								allowOutsideClick: false,
								showConfirmButton: true
							});
						}
						$item.is_quantity_loading = false;
					})
					.catch(error => {
						console.log(error);
						$item.is_quantity_loading = false;
					});
			},
			fetchFeaturedProducts() {
				this.featuredProductsIsLoading = true;
				this.axiosClient.get("<?php echo url('cart.featured-products') ?>")
					.then(response => {
						this.featuredProducts = response.data;
						this.featuredProductsIsLoading = false;
					})
					.catch(error => {
						console.log(error);
						this.featuredProductsIsLoading = false;
					});
			}
		}
	}
</script>
<?php $this->end(); ?>

<style>
	/* SPINNER */
	.checkoutItemQuantitySpinner {
		display: flex;
		justify-content: center;
		align-items: center;
		width: 45px;
		text-align: center;
		background-color: var(--tblr-body-bg);
		border-top: 1px solid var(--tblr-border-color);
		border-bottom: 1px solid var(--tblr-border-color);
	}
</style>
<section x-data="cart()" class="section page-section" x-cloak>
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Shopping Cart')
					]
				]]) ?>
			</div>
		</div>
		<div class="row">
			<div class="col-md-8">
				<?php _message(); ?>
				<div class="card">
					<div class="card-header">
						<h2 class="card-title"><?php e__('Shopping Cart') ?></h2>
					</div>
					<div x-show="isLoading">
						<div class="py-6">
							<div class="d-flex justify-content-center">
								<div class="spinner-border" role="status">
									<span class="sr-only">-/-</span>
								</div>
							</div>
						</div>
					</div>
					<div x-show="items.length === 0 && !isLoading">
						<div class="mt-3 mx-3">
							<?php $this->insert('components/alert', ['type' => 'warning', 'message' => t__('Your shopping cart is empty!')]); ?>
						</div>
					</div>
					<div x-show="!isLoading && items.length > 0" class="card-body p-0">
						<div class="table-responsive">
							<table class="table table-hover">
								<thead>
								<tr>
									<th><?php e__('Product') ?></th>
									<th><?php e__('Price') ?></th>
									<th><?php e__('Quantity') ?></th>
									<th><?php e__('Total') ?></th>
									<th class="text-end">&nbsp;</th>
								</tr>
								</thead>
								<tbody>
								<template x-for="item in items" :key="item.id">
									<tr>
										<td>
											<div x-text="item.name"></div>
											<template x-for="variable in item.variables" :key="variable.id">
												<div x-text="variable.name + ': ' + variable.value" class="small text-muted"></div>
											</template>
										</td>
										<td>
											<span x-show="item.discounted_price_raw != 0" x-text="item.price" class="small text-danger text-decoration-line-through"></span>
											<span x-text="item.discounted_price_raw != 0 ? item.discounted_price : item.price"></span>
										</td>
										<td>
											<div class="input-group" style="width: 95px;">
												<button @click="updateQuantity(item.id, item.quantity - 1)" x-bind:disabled="item.quantity <= 1 || item.disable_quantity" class="btn btn-sm btn-danger" type="button">
													<i class="ti ti-minus icon-sm"></i>
												</button>
												<input x-show="!item.is_quantity_loading" @keyup.enter="updateQuantity(item.id, item.quantity)" type="text" class="form-control form-control-sm text-center px-0" x-model="item.quantity" autocomplete="off">
												<div x-show="item.is_quantity_loading" class="checkoutItemQuantitySpinner">
													<div class="spinner-border spinner-border-sm" role="status">
														<span class="sr-only">...</span>
													</div>
												</div>
												<button @click="updateQuantity(item.id, item.quantity + 1)" x-bind:disabled="item.disable_quantity" class="btn btn-sm btn-success" type="button">
													<i class="ti ti-plus icon-sm"></i>
												</button>
											</div>
										</td>
										<td x-text="item.total"></td>
										<td class="text-end">
											<a x-bind:href="'/store/products/' + item.product_id" class="btn btn-primary btn-icon btn-sm" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Details') ?>">
												<i class="fa fa-info"></i>
											</a>
											<button @click="deleteItem(item.id)" x-bind:disabled="item.is_delete_loading" class="btn btn-danger btn-icon btn-sm" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Remove') ?>">
												<i class="fa fa-times"></i>
											</button>
										</td>
									</tr>
								</template>
								</tbody>
							</table>
						</div>
					</div>
				</div>
				
				<div x-show="featuredProductsStatus">
					<h2 class="h4 mt-5 mb-3"><?php e__('Featured Products') ?></h2>
					<div x-show="!featuredProductsIsLoading && featuredProducts.length === 0">
						<div class="alert alert-warning">
							<?php e__('No data found!') ?>
						</div>
					</div>
					<div x-show="featuredProductsIsLoading" class="row">
						<div class="col-md-4">
							<div class="card">
								<div class="card-body text-center">
									<div class="spinner-border" role="status">
										<span class="sr-only">-/-</span>
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-4">
							<div class="card">
								<div class="card-body text-center">
									<div class="spinner-border" role="status">
										<span class="sr-only">-/-</span>
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-4">
							<div class="card">
								<div class="card-body text-center">
									<div class="spinner-border" role="status">
										<span class="sr-only">-/-</span>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div x-show="!featuredProductsIsLoading" class="row">
						<template x-for="featuredProduct in featuredProducts" :key="featuredProduct.id">
							<div class="col-md-4">
								<div class="card card-product h-auto">
									<div class="stock" :class="featuredProduct.stock == 0 ? 'stock-out' : 'have-stock'" x-show="featuredProduct.stock != -1" x-text="featuredProduct.stock == 0 ? '<?php e__('Out of Stock!') ?>' : '<?php e__('Limited Stock!') ?>'"></div>
									<div class="discount discount-sm" x-show="featuredProduct.discountPercent > 0" x-text="featuredProduct.discountPercent + '%'"></div>
									<div class="card-body py-4">
										<div>
											<img width="60" x-bind:src="featuredProduct.image" class="featuredProductImage">
										</div>
										<div>
											<h4 class="h5 mb-1" x-text="featuredProduct.name"></h4>
											<div class="mb-3">
												<span x-show="featuredProduct.discountedPrice != 0" x-text="featuredProduct.price" class="old-price"></span>
												<span x-text="featuredProduct.discountedPrice != 0 ? featuredProduct.discountedPrice : featuredProduct.price"></span>
											</div>
											
											<button @click="addItem(featuredProduct.id);" class="btn btn-success"><?php e__('Add to Cart') ?></button>
											<a x-bind:href="'/store/products/' + featuredProduct.id" class="btn btn-info btn-icon">
												<i class="fa fa-info"></i>
											</a>
										</div>
									</div>
								</div>
							</div>
						</template>
					</div>
				</div>
			</div>
			<div class="col-md-4">
				<div x-show="cashback_raw > 0">
					<div class="alert alert-info">
						<?php
							e__(
								'You can earn %cashback% (%percent%%) cashback credits for this purchase.',
								[
									'%cashback%' => '<strong x-text="cashback"></strong>',
									'%percent%' => modules('store')->settings('cashback')
								]
							);
						?>
					</div>
				</div>
				<div class="card">
					<div class="card-header">
						<h2 class="card-title fs-100"><?php e__('Order Summary') ?></h2>
					</div>
					<div class="card-body">
						<form data-toggle="form-submit-with-loader" action="<?php echo url('cart.pay') ?>" method="post">
							<?php _csrf(); ?>
							<div id="shoppingCartSummary">
								<div class="row pb-4">
									<div class="col-md-12">
										<span class="form-label"><?php e__('Coupon') ?>:</span>
										<div class="input-group">
											<input type="text" class="form-control" name="coupon" x-bind:disabled="isLoading" x-bind:readonly="coupon !== null" x-model="couponModel">
											<div class="input-group-append">
												<button x-show="coupon === null" x-bind:disabled="couponIsLoading || items.length === 0" @click="applyCoupon()" type="button" class="btn btn-primary" style="border-top-left-radius: 0; border-bottom-left-radius: 0;"><?php e__('Apply') ?></button>
												<button x-show="coupon !== null" x-bind:disabled="couponIsLoading" @click="removeCoupon()" type="button" class="btn btn-danger" style="border-top-left-radius: 0; border-bottom-left-radius: 0;"><?php e__('Remove') ?></button>
											</div>
										</div>
										<small x-show="couponAlert !== null" x-text="couponAlert" :class="couponAlertStatus ? 'text-success' : 'text-danger'"></small>
									</div>
								</div>
								<?php if ($showCreatorCodesInput): ?>
									<div class="row pb-4">
										<div class="col-md-12">
											<span class="form-label"><?php e__('Creator Code') ?>:</span>
											<div class="input-group">
												<input type="text" class="form-control" name="creatorCode" x-bind:disabled="isLoading" x-bind:readonly="creatorCode !== null" x-model="creatorCodeModel">
												<div class="input-group-append">
													<button x-show="creatorCode === null" x-bind:disabled="creatorCodeIsLoading || items.length === 0" @click="applyCreatorCode()" type="button" class="btn btn-primary" style="border-top-left-radius: 0; border-bottom-left-radius: 0;"><?php e__('Apply') ?></button>
													<button x-show="creatorCode !== null" x-bind:disabled="creatorCodeIsLoading" @click="removeCreatorCode()" type="button" class="btn btn-danger" style="border-top-left-radius: 0; border-bottom-left-radius: 0;"><?php e__('Remove') ?></button>
												</div>
											</div>
											<small x-show="creatorCodeAlert !== null" x-text="creatorCodeAlert" :class="creatorCodeAlertStatus ? 'text-success' : 'text-danger'"></small>
										</div>
									</div>
								<?php endif; ?>
								<div x-show="discount_raw > 0" class="row">
									<div class="col">
										<span class="form-label"><?php e__('Discount') ?>:</span>
									</div>
									<div class="col-auto text-end">
										<span class="text-danger" x-text="discount"></span>
									</div>
								</div>
								<div x-show="discount_raw > 0 || tax_raw > 0" class="row">
									<div class="col">
										<span class="form-label"><?php e__('Subtotal') ?>:</span>
									</div>
									<div class="col-auto text-end">
										<span class="text-body" x-text="subtotal"></span>
									</div>
								</div>
								<div x-show="tax_raw > 0" class="row">
									<div class="col">
										<span class="form-label"><?php e__('Tax') ?>:</span>
									</div>
									<div class="col-auto text-end">
										<span class="text-body" x-text="tax"></span>
									</div>
								</div>
								<div class="row pb-3">
									<div class="col align-items-center">
										<span class="form-label mb-0"><?php e__('Total') ?>:</span>
									</div>
									<div class="col-auto text-end">
										<span class="text-success fw-bold fs-3" x-text="total"></span>
									</div>
								</div>
								<?php if (modules('store')->settings('isCreditRequiredOnPurchase') == 0): ?>
									<div class="row pb-3">
										<div class="col">
											<label for="selectPayment" class="form-label mb-1"><?php e__('Payment Method') ?>:</label>
											<select id="selectPayment" class="form-control" name="paymentGatewayID" required="required">
												<?php if (count($paymentGateways) > 0): ?>
													<?php foreach ($paymentGateways as $paymentGateway): ?>
														<option value="<?php echo $paymentGateway["slug"]; ?>">
															<?php echo $paymentGateway["title"]; ?>
														</option>
													<?php endforeach; ?>
												<?php else: ?>
													<option><?php e__('Payment method not found!') ?></option>
												<?php endif; ?>
											</select>
										</div>
									</div>
								<?php else: ?>
									<input type="hidden" name="paymentGatewayID" value="0">
								<?php endif; ?>
								
								<?php if (modules('credit')->isActive() && auth()->user()->credits() != 0 && modules('store')->settings('isCreditRequiredOnPurchase') == 0): ?>
									<div class="row">
										<div class="col">
											<div class="form-check">
												<input name="useBalance" class="form-check-input" type="checkbox" id="useBalance">
												<label class="form-check-label" for="useBalance"><?php e__('Use my %credit% credit(s)', ["%credit%" => '<strong>'.money()->format(auth()->user()->credits()).'</strong>']) ?></label>
											</div>
										</div>
									</div>
								<?php endif; ?>
								
								<?php if (modules('store')->settings('showTermsCheckbox') == 1): ?>
									<div class="row">
										<div class="col">
											<div class="form-check">
												<input name="terms" class="form-check-input" type="checkbox" id="terms" required>
												<label class="form-check-label" for="terms"><?php e__('I agree to the <a href="/terms" target="_blank">Terms & Conditions</a>') ?></label>
											</div>
										</div>
									</div>
								<?php endif; ?>
								<div class="pt-2">
									<button type="submit" name="checkout" id="checkoutButton" class="btn btn-success w-100"><?php e__('Checkout') ?></button>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
