<?php $this->layout('layouts/main'); ?>

<section class="section store-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('store.index'),
						"text" => t__('Store')
					],
					$category["parent"] ? [
						"url" => url('store.categories.show', ['slug' => $category["parent"]["slug"]]),
						"text" => $category["parent"]["name"]
					] : null,
					[
						"text" => $category["name"]
					]
				]]) ?>
			</div>
		</div>
		
		<?php if (modules('store')->settings('communityGoalStatus') == '1'): ?>
			<h2 class="page-title mt-3 mb-1">
				<?php echo modules('store')->settings('communityGoalTitle'); ?>
			</h2>
			<div class="mb-5">
				<div>
					<?php echo modules('store')->settings('communityGoalDescription'); ?>
				</div>
				<div class="mt-2">
					<div class="progress" style="height: 32px;">
						<div class="progress-bar bg-success" role="progressbar" style="width: <?php echo $communityGoalProgress; ?>%" aria-valuenow="<?php echo $communityGoalProgress; ?>" aria-valuemin="0" aria-valuemax="100">
							<?php echo $communityGoalProgress; ?>%
						</div>
					</div>
				</div>
			</div>
		<?php endif; ?>
		
		<?php if (modules('store')->settings('topSalesStatus') == 1): ?>
			<?php if (count($category["topSales"]) > 0): ?>
				<h2 class="page-title mt-3 mb-3"><?php e__('Bestseller') ?></h2>
				<div class="row row-gap-3 mb-5">
					<?php foreach ($category["topSales"] as $product): ?>
						<div class="col-md-3 col-sm-6">
							<div class="card card-product card-hover">
								<?php if ($product["stock"] != -1): ?>
									<div class="stock <?php echo ($product["stock"] == 0) ? "stock-out" : "have-stock"; ?>">
										<?php if ($product["stock"] == 0): ?>
											<?php e__('Out of Stock!') ?>
										<?php else : ?>
											<?php e__('Limited Stock!') ?>
										<?php endif; ?>
									</div>
								<?php endif; ?>
								
								<?php if ($product["discounted"]): ?>
									<div class="discount">
										<span><?php echo $product["discountPercent"]; ?>%</span>
									</div>
								<?php endif; ?>
								<img class="card-img-top lazyload" data-src="<?php echo $product["image"]; ?>" src="/assets/core/images/loaders/store.png" alt="<?php echo $product["name"]; ?>">
								<div class="card-body">
									<h3 class="fs-lg fw-medium my-2">
										<?php echo $product["name"]; ?>
									</h3>
									<span class="text-heading fw-semibold mb-2">
										<?php if ($product["discounted"]): ?>
											<span class="old-price"><?php echo money()->format($product["price"]); ?></span>
											<small>/</small>
											<span class="price"><?php echo money()->format($product["discountedPrice"]); ?></span>
										<?php else: ?>
											<span class="price"><?php echo money()->format($product["price"]); ?></span>
										<?php endif; ?>
									</span>
									
									<div class="mt-auto">
										<?php if ($product["stock"] != -1): ?>
											<div class="mb-2">
												<?php if ($product["stock"] == 0): ?>
													<span class="text-danger small"><?php e__('Out of Stock!') ?></span>
												<?php else : ?>
													<span class="text-success small"><?php e__('%stock% in stock', ['%stock%' => $product["stock"]]) ?></span>
												<?php endif; ?>
											</div>
										<?php endif; ?>
										<?php if ($product["stock"] == 0): ?>
											<button class="btn btn-danger w-100 stretched-link disabled"><?php e__('Out of Stock!') ?></button>
										<?php else: ?>
											<?php if ($product["restricted"]): ?>
												<button class="btn btn-primary w-100 stretched-link disabled">
													<i class="ti ti-shopping-cart me-1"></i>
													<?php e__('Buy Now') ?>
												</button>
											<?php elseif ($product["upgradable"]): ?>
												<a href="<?php echo url('store.products.show', ['id' => $product["id"]]); ?>" class="btn btn-primary w-100 stretched-link">
													<i class="ti ti-arrow-up me-1"></i>
													<?php e__('Upgrade') ?>
												</a>
											<?php else: ?>
												<a href="<?php echo url('store.products.show', ['id' => $product["id"]]); ?>" class="btn btn-primary w-100 stretched-link">
													<i class="ti ti-shopping-cart me-1"></i>
													<?php e__('Buy Now') ?>
												</a>
											<?php endif; ?>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			<?php endif; ?>
		<?php endif; ?>
		
		<?php if (count($category["subcategories"]) > 0): ?>
			<h2 class="page-title mt-3 mb-3"><?php e__('Categories') ?></h2>
			<div class="row mb-5 store-categories">
				<?php foreach ($category["subcategories"] as $subcategory): ?>
					<div class="col-md-3">
						<a class="card" href="<?php echo url('store.categories.show', ['slug' => $subcategory["slug"]]) ?>">
							<img class="card-img-top lazyload" data-src="<?php echo $subcategory["image"] ?>" src="/assets/core/images/loaders/server.png">
							<div class="card-body">
								<h3 class="card-title">
									<?php echo $subcategory["name"]; ?>
								</h3>
							</div>
						</a>
					</div>
				<?php endforeach; ?>
			</div>
		<?php endif; ?>
		
		<?php if (count($category["products"]) > 0): ?>
			<h2 class="page-title mt-3 mb-3"><?php e__('Products') ?></h2>
			<div class="row row-gap-3">
				<?php foreach ($category["products"] as $product): ?>
					<div class="col-md-3 col-sm-6">
						<div class="card card-product card-hover">
							<?php if ($product["stock"] != -1): ?>
								<div class="stock <?php echo ($product["stock"] == 0) ? "stock-out" : "have-stock"; ?>">
									<?php if ($product["stock"] == 0): ?>
										<?php e__('Out of Stock!') ?>
									<?php else : ?>
										<?php e__('Limited Stock!') ?>
									<?php endif; ?>
								</div>
							<?php endif; ?>
							
							<?php if ($product["discounted"]): ?>
								<div class="discount">
									<span><?php echo $product["discountPercent"]; ?>%</span>
								</div>
							<?php endif; ?>
							<img class="card-img-top lazyload" data-src="<?php echo $product["image"]; ?>" src="/assets/core/images/loaders/store.png" alt="<?php echo $product["name"]; ?>">
							<div class="card-body">
								<h3 class="fs-lg fw-medium my-2">
									<?php echo $product["name"]; ?>
								</h3>
								<span class="text-heading fw-semibold mb-2">
									<?php if ($product["discounted"]): ?>
										<span class="old-price"><?php echo money()->format($product["price"]); ?></span>
										<small>/</small>
										<span class="price"><?php echo money()->format($product["discountedPrice"]); ?></span>
									<?php else: ?>
										<span class="price"><?php echo money()->format($product["price"]); ?></span>
									<?php endif; ?>
								</span>
								
								<div class="mt-auto">
									<?php if ($product["stock"] != -1): ?>
										<div class="mb-2">
											<?php if ($product["stock"] == 0): ?>
												<span class="text-danger small"><?php e__('Out of Stock!') ?></span>
											<?php else : ?>
												<span class="text-success small"><?php e__('%stock% in stock', ['%stock%' => $product["stock"]]) ?></span>
											<?php endif; ?>
										</div>
									<?php endif; ?>
									<?php if ($product["stock"] == 0): ?>
										<button class="btn btn-danger w-100 stretched-link disabled"><?php e__('Out of Stock!') ?></button>
									<?php else: ?>
										<?php if ($product["restricted"]): ?>
											<button class="btn btn-primary w-100 stretched-link disabled">
												<i class="ti ti-shopping-cart me-1"></i>
												<?php e__('Buy Now') ?>
											</button>
										<?php elseif ($product["upgradable"]): ?>
											<a href="<?php echo url('store.products.show', ['id' => $product["id"]]); ?>" class="btn btn-primary w-100 stretched-link">
												<i class="ti ti-arrow-up me-1"></i>
												<?php e__('Upgrade') ?>
											</a>
										<?php else: ?>
											<a href="<?php echo url('store.products.show', ['id' => $product["id"]]); ?>" class="btn btn-primary w-100 stretched-link">
												<i class="ti ti-shopping-cart me-1"></i>
												<?php e__('Buy Now') ?>
											</a>
										<?php endif; ?>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
		<?php else: ?>
			<?php if (count($category["subcategories"]) == 0): ?>
				<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No product were found!')]); ?>
			<?php endif; ?>
		<?php endif; ?>
	</div>
</section>