<?php $this->layout('layouts/main'); ?>

<section class="section store-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Store')
					]
				]]) ?>
			</div>
		</div>
		<div class="row">
			<?php if (count($categories) > 0): ?>
				<?php foreach ($categories as $category): ?>
					<div class="col-md-4">
						<a class="card" href="<?php echo url('store.categories.show', ['slug' => $category["slug"]]) ?>">
							<img class="card-img-top lazyload" data-src="<?php echo $category["image"] ?>" src="/assets/core/images/loaders/server.png">
							<div class="card-body">
								<h3 class="card-title">
									<?php echo $category["name"]; ?>
								</h3>
							</div>
						</a>
					</div>
				<?php endforeach; ?>
			<?php else: ?>
				<div class="col-md-12">
					<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No category were found!')]); ?>
				</div>
			<?php endif; ?>
		</div>
	</div>
</section>