<?php $this->layout('layouts/main') ?>
<section class="section page-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('store.index'),
						"text" => t__("Store")
					],
					[
						"url" => url('store.categories.show', ['slug' => $product["category"]["slug"]]),
						"text" => $product["category"]["name"]
					],
					[
						"text" => $product["name"]
					]
				]]) ?>
			</div>
			<div class="col-md-8">
				<?php _message(); ?>
				<div class="card">
					<div class="card-body py-4">
						<div class="row">
							<div class="col-md-4">
								<img data-src="<?php echo $product["image"] ?>" alt="" class="lazyload w-100 mb-2" src="/assets/core/images/loaders/store.png">
							</div>
							<div class="col-md-8">
								<div>
									<p class="mb-0 opacity-75 small text-uppercase fw-semibold"><?php echo $product["category"]["name"] ?></p>
									<h2 class="h2 mb-2"><?php echo $product["name"]; ?></h2>
									<div class="d-flex gap-2">
										<div class="px-2 py-1 rounded fw-semibold bg-info text-white">
											<?php if ($product["duration"] == 0): ?>
												<?php e__('Lifetime') ?>
											<?php elseif ($product["duration"] == -1): ?>
												<?php e__('One-Time') ?>
											<?php else : ?>
												<?php e__('%day% day(s)', ['%day%' => $product["duration"]]) ?>
											<?php endif; ?>
										</div>
										<?php if ($product["discountPercent"] > 0): ?>
											<div class="px-2 py-1 rounded fw-semibold bg-success text-white"><?php e__('%discount%% OFF!', ['%discount%' => $product["discountPercent"]]) ?></div>
										<?php endif; ?>
										<?php if ($product["stock"] != -1): ?>
											<div class="px-2 py-1 rounded fw-semibold text-white <?php echo ($product["stock"] == 0) ? "bg-danger" : "bg-warning"; ?>">
												<?php if ($product["stock"] == 0): ?>
													<?php e__('Out of Stock!') ?>
												<?php else : ?>
													<?php e__('Limited Stock!') ?>
												<?php endif; ?>
											</div>
										<?php endif; ?>
									</div>
								</div>
								<hr>
								<div class="ck-content mt-4">
									<?php echo $product["details"]; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-4">
				<div class="card">
					<div class="card-header">
						<h2 class="card-title fs-100"><?php e__('Order Summary') ?></h2>
					</div>
					<div class="card-body">
						<form data-toggle="form-submit-with-loader" action="<?php echo url('cart.items.add') ?>" method="post">
							<?php _csrf(); ?>
							<input type="hidden" name="productID" value="<?php echo $product['id'] ?>">
							<input type="hidden" name="quantity" value="1">
							
							<?php if ($product["discount"] > 0 || $product["tax"] > 0): ?>
								<div class="row">
									<div class="col align-items-center">
										<span class="form-label"><?php e__('Subtotal') ?>:</span>
									</div>
									<div class="col-auto text-end">
										<span class="text-body">
											<?php echo money()->format($product["subtotal"]); ?>
										</span>
									</div>
								</div>
							<?php endif; ?>
							
							<?php if ($product["tax"] > 0): ?>
								<div class="row">
									<div class="col align-items-center">
										<span class="form-label"><?php e__('Tax') ?>:</span>
									</div>
									<div class="col-auto text-end">
										<span class="text-body">
											<?php echo money()->format($product["tax"]); ?>
										</span>
									</div>
								</div>
							<?php endif; ?>
							
							<?php if ($product["discount"] > 0): ?>
								<div class="row">
									<div class="col align-items-center">
										<span class="form-label"><?php e__('Discount') ?>:</span>
									</div>
									<div class="col-auto text-end">
										<span class="text-danger">
											<?php echo money()->format($product["discount"]); ?>
										</span>
									</div>
								</div>
							<?php endif; ?>
							
							<div class="row">
								<div class="col align-items-center">
									<span class="form-label mb-0"><?php e__('Total') ?>:</span>
								</div>
								<div class="col-auto text-end">
									<span class="text-success fw-bold fs-3">
										<?php echo money()->format($product["total"]); ?>
									</span>
								</div>
							</div>
							
							<div class="pt-4">
								<?php if (auth()->check()): ?>
									<button type="submit" class="btn btn-success w-100"><?php e__('Add to Cart') ?></button>
								<?php else: ?>
									<a href="<?php echo url('auth.login') ?>" class="btn btn-success w-100">
										<?php e__('Login') ?>
									</a>
								<?php endif; ?>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>