<?php $this->layout('layouts/main'); ?>

<section class="section store-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('store.index'),
						"text" => t__('Store')
					],
					[
						"text" => $category["name"]
					]
				]]) ?>
			</div>
		</div>
		<?php if (count($tierList["tiers"]) > 0): ?>
			<style type="text/css">
				.table-header {
					font-weight: bold;
					background-color: #f8f8f8 !important;
				}
				[data-bs-theme=dark] .table-header {
					background-color: #151F2C !important;
				}
			</style>
			<div class="row">
				<div class="col-md-12">
					<div class="card">
						<div class="table-responsive vip-table">
							<table class="table table-hover mb-0">
								<thead>
								<tr>
									<th scope="col"></th>
									<?php foreach ($tierList["tiers"] as $tier): ?>
										<th class="py-4 text-center" style="text-transform: none; font-size: inherit">
											<div class="position-relative d-inline-flex">
												<div class="card-product text-body">
													<?php if ($tier["discounted"]): ?>
														<div class="discount discount-sm" style="right: -1rem;">
															<span><?php echo $tier["discountPercent"]; ?>%</span>
														</div>
													<?php endif; ?>
													<img class="store-card-img lazyload" data-src="<?php echo $tier["image"]; ?>" src="/assets/core/images/loaders/store.png" style="max-width: 150px">
													<div class="row store-card-text d-flex flex-column">
														<span class="d-block h3 mb-2 mt-3"><?php echo $tier["name"]; ?></span>
														<div class="d-block">
															<?php if ($tier["discounted"]): ?>
																<span class="old-price"><?php echo money()->format($tier["price"]); ?></span>
																<small>/</small>
																<span class="price"><?php echo money()->format($tier["discountedPrice"]); ?></span>
															<?php else: ?>
																<span class="price"><?php echo money()->format($tier["price"]); ?></span>
															<?php endif; ?>
														</div>
													</div>
													<div class="store-card-button">
														<div class="mb-2" style="visibility: <?php echo $tier["stock"] == -1 ? 'hidden' : 'initial'; ?>">
															<?php if ($tier["stock"] == 0): ?>
																<span class="text-danger small">
																	<?php e__('Out of Stock!') ?>
																</span>
															<?php else: ?>
																<span class="text-success small">
																	<?php e__('%stock% in stock', ['%stock%' => $tier["stock"]]) ?>
																</span>
															<?php endif; ?>
														</div>
														<?php if ($tier["stock"] == 0): ?>
															<button class="btn btn-danger stretched-link disabled">
																<?php e__('Out of Stock!') ?>
															</button>
														<?php else: ?>
															<?php if ($tier["restricted"]): ?>
																<button class="btn btn-success stretched-link disabled">
																	<?php e__('Buy Now') ?>
																</button>
															<?php elseif ($tier["upgradable"]): ?>
																<a href="<?php echo url('store.products.show', ['id' => $tier["id"]]); ?>" class="btn btn-primary stretched-link">
																	<?php e__('Upgrade') ?>
																</a>
															<?php else: ?>
																<a href="<?php echo url('store.products.show', ['id' => $tier["id"]]); ?>" class="btn btn-primary stretched-link">
																	<?php e__('Buy Now') ?>
																</a>
															<?php endif; ?>
														<?php endif; ?>
													</div>
												</div>
											</div>
										</th>
									<?php endforeach; ?>
								</tr>
								</thead>
								<tbody>
								<?php foreach ($tierList["titles"] as $title): ?>
									<?php if (count($title["descriptions"]) == 0): ?>
										<tr class="sep">
											<td colspan="<?php echo count($tierList["tiers"]) + 1; ?>" class="text-start table-header">
												<?php echo $title["title"]; ?>
											</td>
										</tr>
									<?php else: ?>
										<tr>
											<td class="text-start">
												<?php echo $title["title"]; ?>
												<?php if ($title["explain"] != null): ?>
													<i class="ti ti-info-circle-filled" data-bs-toggle="tooltip" title="<?php echo $title["explain"]; ?>"></i>
												<?php endif; ?>
											</td>
											<?php foreach ($title["descriptions"] as $description): ?>
												<td class="text-center">
													<?php if ($description == '-'): ?>
														<i class="ti ti-x text-danger"></i>
													<?php elseif ($description == '+'): ?>
														<i class="ti ti-check text-success"></i>
													<?php else: ?>
													  <?php echo $description; ?>
													<?php endif; ?>
												</td>
											<?php endforeach; ?>
										</tr>
									<?php endif; ?>
								<?php endforeach; ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		<?php endif; ?>
	</div>
</section>