<?php $this->layout('layouts/main'); ?>

<?php if (recaptcha()->isEnabled('post_suggestion')) : ?>
	<?php $this->push('head'); ?>
	<?php echo recaptcha()->getScript(); ?>
	<?php $this->end(); ?>
<?php endif; ?>

<?php $this->push('scripts'); ?>
<script src="<?php echo $this->asset('/js/plugins/ckeditor/ckeditor.js') ?>"></script>
<script src="<?php echo $this->asset('/js/ckeditor5.js') ?>"></script>
<?php $this->end(); ?>

<section class="section forum-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('suggestions.index'),
						"text" => t__('Suggestions')
					],
					[
						"text" => t__('Post Suggestion')
					]
				]]) ?>
			</div>
		</div>
		
		<div class="col-md-12">
			<?php _message(); ?>
			<div class="card mb-0">
				<div class="card-header">
					<h2 class="card-title"><?php e__('Post Suggestion') ?></h2>
				</div>
				<div class="card-body">
					<div class="forum-content">
						<form data-toggle="form-submit-with-loader" action="<?php echo url('suggestions.store') ?>" method="post">
							<?php _csrf(); ?>
							<div class="mb-3">
								<label for="categoryID" class="form-label"><?php e__('Category') ?></label>
								<select name="categoryID" id="categoryID" class="form-control">
									<?php if (count($categories) > 0): ?>
										<?php foreach ($categories as $category): ?>
											<option value="<?php echo $category["id"] ?>" <?php _selected(old('categoryID') == $category["id"]); ?>>
												<?php echo $category["name"]; ?>
											</option>
										<?php endforeach; ?>
									<?php else: ?>
										<option disabled selected><?php e__('Not Found!') ?></option>
									<?php endif; ?>
								</select>
							</div>
							<div class="mb-3">
								<label for="title" class="form-label"><?php e__('Title') ?></label>
								<input type="text" class="form-control" id="title" name="title" value="<?php _old('title'); ?>">
							</div>
							<div class="mb-3">
								<textarea
									id="ckeditor"
									name="message"
									placeholder=""
									class="form-control"
									style="min-height: 500px;"
									data-upload="<?php echo url('suggestions.upload') ?>"
									data-csrf="<?php echo csrf_token(); ?>"><?php _old('message'); ?></textarea>
							</div>
							<?php if (recaptcha()->isEnabled('post_suggestion')) : ?>
								<div class="mb-3 d-flex justify-content-end">
									<?php echo recaptcha()->getHTML() ?>
								</div>
							<?php endif; ?>
							<div class="d-flex justify-content-end">
								<button type="submit" class="btn btn-primary">
									<?php e__('Post Suggestion') ?>
								</button>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
