<?php $this->layout('layouts/main'); ?>

<?php $this->push('scripts'); ?>
<script src="<?php echo $this->asset('/js/plugins/ckeditor/ckeditor.js') ?>"></script>
<script src="<?php echo $this->asset('/js/ckeditor5.js') ?>"></script>
<?php $this->end(); ?>

<section class="section forum-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('suggestions.index'),
						"text" => t__('Suggestions')
					],
					[
						"url" => url('suggestions.show', ['id' => $suggestion["id"], 'slug' => $suggestion["slug"]]),
						"text" => $suggestion["title"]
					],
					[
						"text" => t__('Edit Suggestion')
					]
				]]) ?>
			</div>
		</div>
		
		<div class="card mb-0">
			<div class="card-header">
				<h2 class="card-title"><?php e__('Edit the suggestion') ?></h2>
			</div>
			<div class="card-body">
				<div class="forum-content">
					<form data-toggle="form-submit-with-loader" action="<?php echo url('suggestions.update', ['id' => $suggestion["id"]]) ?>" method="post">
						<?php _method('PATCH'); ?>
						<?php _csrf(); ?>
						<div class="mb-3">
							<label for="categoryID"><?php e__('Category') ?></label>
							<select name="categoryID" id="categoryID" class="form-control">
								<?php if (count($categories) > 0): ?>
									<?php foreach ($categories as $category): ?>
										<option value="<?php echo $category["id"] ?>" <?php _selected(old('categoryID', $suggestion["categoryID"]) == $category["id"]); ?>>
											<?php echo $category["name"]; ?>
										</option>
									<?php endforeach; ?>
								<?php else: ?>
									<option disabled selected><?php e__('Not Found!') ?></option>
								<?php endif; ?>
							</select>
						</div>
						<div class="mb-3">
							<label for="title"><?php e__('Title') ?></label>
							<input type="text" class="form-control" id="title" name="title" value="<?php _old('title', $suggestion["title"]); ?>">
						</div>
						<div class="mb-3">
							<textarea
								id="ckeditor"
								name="message"
								placeholder=""
								class="form-control"
								style="min-height: 500px;"
								data-upload="<?php echo url('suggestions.upload') ?>"
								data-csrf="<?php echo csrf_token(); ?>"><?php _old('message', $suggestion["content"]); ?></textarea>
						</div>
						<div class="d-flex justify-content-end">
							<button type="submit" class="btn btn-primary">
								<?php e__('Save Changes') ?>
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</section>
