<?php $this->layout('layouts/main'); ?>

<section class="section forum-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Suggestions')
					],
				]]) ?>
			</div>
		</div>
		
		<div class="row">
			<div class="col-md-9">
				<?php if (count($suggestions) > 0): ?>
					<div class="card">
						<div class="card-header justify-content-between py-3">
							<h2 class="card-title"><?php e__('Suggestions') ?></h2>
							<div class="btn-group dropdown">
								<button class="btn btn-sm btn-primary dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
									<?php
										$sort = t__('Newest');
										if (get("sort") == "recent-activity") $sort = t__('Recent Activity');
										if (get("sort") == "likes") $sort = t__('Likes');
									?>
									<?php e__('Sort by %filter%', ['%filter%' => $sort]); ?>
								</button>
								<div class="dropdown-menu dropdown-menu-end" style="z-index: 999999">
									<a href="?sort=newest" class="dropdown-item">
										<?php e__('Newest') ?>
									</a>
									<a href="?sort=recent-activity" class="dropdown-item">
										<?php e__('Recent Activity') ?>
									</a>
									<a href="?sort=likes" class="dropdown-item">
										<?php e__('Likes') ?>
									</a>
								</div>
							</div>
						</div>
						<div class="card-body py-0 border-bottom-separator" style="z-index: 0;">
							<?php foreach ($suggestions as $suggestion): ?>
								<div class="row align-items-center">
									<div class="col-auto pe-1 d-none d-md-block">
										<?php $this->insert("components/avatar", [
											'avatar' => $suggestion["user"]["avatar"],
											'username' => $suggestion["user"]["displayName"],
											'class' => 'avatar'
										]) ?>
									</div>
									<div class="col">
										<a href="<?php echo url('suggestions.show', ['id' => $suggestion["id"], 'slug' => $suggestion["slug"]]); ?>" class="fw-bold">
											<?php echo $suggestion["title"]; ?>
										</a>
										<div class="small">
											<a href="<?php echo url('members.show', ['id' => $suggestion["user"]["id"]]); ?>" class="text-body"><?php echo $suggestion["user"]["displayName"]; ?></a>
											<span>•</span>
											<span><?php echo carbon($suggestion["creationDate"])->intlFormat(); ?></span>
										</div>
									</div>
									<div class="col-auto small">
										<div class="text-success d-flex align-items-center gap-1 mb-1">
											<i class="ti ti-thumb-up" style="font-size: 18px;"></i> <strong><?php echo $suggestion["likesCount"] ?></strong>
										</div>
										<div class="text-danger d-flex align-items-center gap-1">
											<i class="ti ti-thumb-down" style="font-size: 18px;"></i> <strong><?php echo $suggestion["dislikesCount"] ?></strong>
										</div>
									</div>
								</div>
							<?php endforeach; ?>
						</div>
					</div>
					
					<div class="col-md-12 d-flex justify-content-center mt-4 mb-4">
						<?php $this->insert('components/pagination', [
							'page' => $page,
							'pageCount' => $pageCount,
						]) ?>
					</div>
				<?php else: ?>
					<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('No suggestions were found!')]); ?>
				<?php endif; ?>
			</div>
			
			<div class="col-md-3">
				<?php if (auth()->check()): ?>
					<a href="<?php echo url('suggestions.create') ?>" class="btn btn-primary w-100 mb-3">
						<i class="ti ti-plus me-1 d-none d-md-inline-block"></i>
						<?php e__('Post Suggestion') ?>
					</a>
				<?php endif; ?>
				<div class="card">
					<div class="card-header">
						<h2 class="card-title fs-100"><?php e__('Categories') ?></h2>
					</div>
					<?php if (count($categories) > 0): ?>
						<div class="card-body p-0">
							<ul class="list-group list-group-flush linked-list">
								<?php foreach ($categories as $categoryItem): ?>
									<li class="list-group-item <?php _active(isset($category) && $categoryItem["slug"] == $category["slug"]); ?>">
										<a href="<?php echo url('suggestions.categories.show', ['slug' => $categoryItem["slug"]]); ?>">
											<?php echo $categoryItem["name"]; ?>
										</a>
									</li>
								<?php endforeach; ?>
							</ul>
						</div>
					<?php else: ?>
					  <div class="card-body">
							<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__('Category not found!')]); ?>
					  </div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</section>
