<?php $this->layout('layouts/main'); ?>

<?php if (recaptcha()->isEnabled('reply_suggestion')) : ?>
	<?php $this->push('head'); ?>
	<?php echo recaptcha()->getScript(); ?>
	<?php $this->end(); ?>
<?php endif; ?>

<?php $this->push('scripts'); ?>
<script src="<?php echo $this->asset('/js/plugins/ckeditor/ckeditor.js') ?>"></script>
<script src="<?php echo $this->asset('/js/ckeditor5.js') ?>"></script>
<?php $this->end(); ?>

<section class="section forum-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('suggestions.index'),
						"text" => t__('Suggestions')
					],
					[
						"text" => $suggestion["title"]
					]
				]]) ?>
			</div>
		</div>
		
		<div class="mb-3 mt-3">
			<h1 class="page-title mb-3"><?php echo $suggestion["title"]; ?></h1>
			<div class="d-flex" style="font-size: 14px;">
				<span class="d-flex align-items-center gap-1 me-3">
					<i class="ti ti-user"></i>
					<a class="text-body username__<?php echo $suggestion["user"]["primaryRole"]["slug"] ?>" href="<?php echo url('members.show', ['id' => $suggestion["user"]["id"]]) ?>">
						<?php echo $suggestion["user"]["displayName"]; ?>
					</a>
				</span>
				<span class="d-flex align-items-center gap-1 me-3">
					<i class="ti ti-clock"></i>
					<?php echo carbon($suggestion["creationDate"])->intlFormat(); ?>
				</span>
				<span class="d-flex align-items-center gap-1 me-3">
					<i class="ti ti-folder"></i>
					<a href="<?php echo url('suggestions.categories.show', ['slug' => $suggestion["category"]["slug"]]) ?>" class="text-body">
						<?php echo $suggestion["category"]["name"]; ?>
					</a>
				</span>
				<span class="d-flex align-items-center gap-1 me-3">
					<i class="ti ti-eye"></i>
					<?php echo $suggestion["views"]; ?>
				</span>
			</div>
		</div>
		<style>
			.forum-avatar img {
				border-radius: 0.25rem !important;
			}
		</style>
		<div class="mb-4">
			<div class="row">
				<div class="col-md-3">
					<div class="card mb-1">
						<div class="card-body text-center">
							<a href="<?php echo url('members.show', ['id' => $suggestion["user"]["id"]]); ?>" class="d-block">
								<div class="forum-avatar mb-2">
									<?php $this->insert("components/avatar", [
										'avatar' => $suggestion["user"]["avatar"],
										'username' => $suggestion["user"]["displayName"],
										'class' => 'avatar'
									]) ?>
								</div>
								<span class="d-block mb-2 fw-bold text-body username__<?php echo $suggestion["user"]["primaryRole"]["slug"] ?>">
									<?php echo $suggestion["user"]["displayName"]; ?>
								</span>
							</a>
							<?php foreach ($suggestion["user"]["roles"] as $role): ?>
								<span class="role__default <?php echo "role__".$role["slug"] ?>">
									<?php echo $role["name"]; ?>
								</span>
							<?php endforeach; ?>
						</div>
					</div>
				</div>
				<div class="col-md-9 ps-lg-0">
					<div class="card mb-1 h-100">
						<div class="card-body" style="padding-bottom: 4rem;">
							<div class="forum-content h-100">
								<?php echo $suggestion["content"]; ?>
							</div>
							<div class="border-top small pt-lg-2">
								<div class="row align-items-center">
									<div class="col">
										<div class="d-flex">
											<div>
												<form data-toggle="form-submit-with-loader" action="<?php echo url('suggestions.reaction', ['id' => $suggestion["id"]]); ?>" method="post">
													<?php _csrf(); ?>
													<input type="hidden" name="reaction" value="upvote">
													<button type="submit" class="btn-link no-underline d-flex align-items-center gap-1 text-success">
														<i class="icon-tada ti ti-thumb-up<?php echo $suggestion["isLiked"] ? "-filled" : null; ?>"></i>
														<strong><?php echo $suggestion["likes"]; ?></strong>
													</button>
												</form>
											</div>
											<div>
												<form data-toggle="form-submit-with-loader" action="<?php echo url('suggestions.reaction', ['id' => $suggestion["id"]]); ?>" method="post">
													<?php _csrf(); ?>
													<input type="hidden" name="reaction" value="downvote">
													<button type="submit" class="btn-link no-underline d-flex align-items-center gap-1 text-danger">
														<i class="ti ti-thumb-down<?php echo $suggestion["isDisliked"] ? "-filled" : null; ?>"></i>
														<strong><?php echo $suggestion["dislikes"]; ?></strong>
													</button>
												</form>
											</div>
										</div>
									</div>
									<?php if ($suggestion["canEdit"]): ?>
										<div class="col-auto">
											<div class="d-flex">
													<a href="<?php echo url('suggestions.edit', ['id' => $suggestion["id"]]); ?>" class="me-2 no-underline d-flex align-items-center gap-1">
														<i class="ti ti-edit icon-sm"></i> <?php e__('Edit') ?>
													</a>
													<form data-toggle="form-submit-with-loader" action="<?php echo url('suggestions.destroy', ['id' => $suggestion["id"]]); ?>" method="post">
														<?php _method('DELETE'); ?>
														<?php _csrf(); ?>
														<button type="submit" class="btn-link no-underline text-danger d-flex align-items-center gap-1 clickdelete">
															<i class="ti ti-trash icon-sm"></i> <?php e__('Delete') ?>
														</button>
													</form>
											</div>
										</div>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php foreach ($suggestion["replies"] as $reply): ?>
			<div class="mb-2">
				<div class="row">
					<div class="col-md-3">
						<div class="card mb-1">
							<div class="card-body text-center">
								<a href="<?php echo url('members.show', ['id' => $reply["user"]["id"]]); ?>" class="d-block">
									<div class="forum-avatar mb-2">
										<?php $this->insert("components/avatar", [
											'avatar' => $reply["user"]["avatar"],
											'username' => $reply["user"]["displayName"],
											'class' => 'avatar'
										]) ?>
									</div>
									<span class="d-block mb-2 fw-bold text-body username__<?php echo $reply["user"]["primaryRole"]["slug"] ?>">
										<?php echo $reply["user"]["displayName"]; ?>
									</span>
								</a>
								<?php foreach ($reply["user"]["roles"] as $role): ?>
									<span class="role__default <?php echo "role__".$role["slug"] ?>">
										<?php echo $role["name"]; ?>
									</span>
								<?php endforeach; ?>
							</div>
						</div>
					</div>
					<div class="col-md-9 ps-lg-0">
						<div class="card mb-1 h-100">
							<div class="card-body" style="padding-bottom: 4rem;">
								<div class="forum-content h-100">
									<?php echo $reply["message"]; ?>
								</div>
								<div class="border-top small pt-2">
									<div class="row">
										<div class="col">
											<?php echo carbon($reply["creationDate"])->intlFormat(); ?>
										</div>
										<?php if ($reply["canEdit"]): ?>
											<div class="col-auto">
												<div class="d-flex">
														<a href="<?php echo url('suggestions.replies.edit', ['id' => $reply["id"]]); ?>" class="me-2 no-underline d-flex align-items-center gap-1">
															<i class="ti ti-edit icon-sm"></i> <?php e__('Edit') ?>
														</a>
														<form data-toggle="form-submit-with-loader" action="<?php echo url('suggestions.replies.destroy', ['id' => $reply["id"]]); ?>" method="post" class="d-inline-block">
															<?php _method('DELETE'); ?>
															<?php _csrf(); ?>
															<button type="submit" class="btn-link no-underline text-danger d-flex align-items-center gap-1 clickdelete">
																<i class="ti ti-trash icon-sm"></i> <?php e__('Delete') ?>
															</button>
														</form>
												</div>
											</div>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php endforeach; ?>
		<?php if (auth()->check()): ?>
			<div class="row mt-4">
				<div class="col-md-3">
					<div class="card mb-1">
						<div class="card-body text-center">
							<div class="forum-avatar mb-2">
								<?php $this->insert("components/avatar", [
									'avatar' => auth()->user()->avatar(),
									'username' => auth()->user()->displayName(),
									'class' => 'avatar'
								]) ?>
							</div>
							<span class="d-block mb-2 fw-bold"><?php echo auth()->user()->displayName(); ?></span>
						</div>
					</div>
				</div>
				<div class="col-md-9 ps-lg-0">
					<div class="card mb-1">
						<div class="card-body">
							<?php _message(); ?>
							<div class="forum-content">
								<form data-toggle="form-submit-with-loader" action="<?php echo url('suggestions.reply', ['id' => $suggestion['id']]) ?>" method="post">
									<?php _csrf(); ?>
									<textarea
										id="ckeditor"
										name="message"
										placeholder="<?php e__('Write your reply here...') ?>"
										class="form-control"
										data-upload="<?php echo url('suggestions.upload') ?>"
										data-csrf="<?php echo csrf_token(); ?>"><?php _old('message') ?></textarea>
									<?php if (recaptcha()->isEnabled('reply_suggestion')) : ?>
										<div class="mt-3 d-flex justify-content-end">
											<?php echo recaptcha()->getHTML() ?>
										</div>
									<?php endif; ?>
									<div class="d-flex justify-content-end mt-3">
										<button type="submit" name="sendReply" class="btn btn-primary">
											<?php e__('Send') ?>
										</button>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php else: ?>
			<?php $this->insert('components/alert', ['type' => 'warning', 'message' => t__('You need to be signed in to reply.')]); ?>
		<?php endif; ?>
	</div>
</section>
