<?php $this->layout('layouts/main'); ?>

<style>
	[x-cloak] { display: none !important; }
	
	/* SPINNER */
	.checkoutItemQuantitySpinner {
		display: flex;
		align-items: center;
		justify-content: center;
		width: 40px;
		text-align: center;
		background-color: #fff;
		border-top: 1px solid #cad1d7;
		border-bottom: 1px solid #cad1d7;
	}
	.dark .checkoutItemQuantitySpinner {
		background-color: #2b2b2b;
		border-color: #2b2b2b;
	}
	
	.shoppingCartSpinner {
		display: flex;
		justify-content: center;
		align-items: center;
		width: 100%;
		height: 100%;
	}
	
	.shopping-cart-loading {
		height: 10rem;
		overflow: visible;
	}
	
	.shopping-cart-loading> :not(.shoppingCartSpinner) {
		display: none;
	}
</style>
<script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.13.5/dist/cdn.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/js-cookie@3.0.5/dist/js.cookie.min.js"></script>
<script defer src="https://js.tebex.io/v/1.js"></script>

<script>
	const tebexCompleteUrl = "<?php echo website_url(url('payment.success')); ?>";
	const tebexCancelUrl = "<?php echo website_url(url('payment.error')); ?>";
</script>
<script src="<?php echo $this->asset('/js/tebex_store.js'); ?>"></script>

<section
	x-cloak
	x-data="tebexStoreCart('<?php echo modules('tebex_store')->settings('publicKey'); ?>')"
	class="section page-section"
>
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('store.index'),
						"text" => t__("Store")
					],
					[
						"text" => t__("Shopping Cart")
					],
				]]) ?>
			</div>
		</div>
		<div class="row">
			<div class="col-md-8">
				<div class="card">
					<div class="card-header">
						<h2 class="card-title"><?php e__('Shopping Cart') ?></h2>
					</div>
					<div x-show="isLoading">
						<div class="card-body p-0 shopping-cart-loading">
							<div class="shoppingCartSpinner">
								<div class="spinner-border text-default" role="status">
									<span class="sr-only">-/-</span>
								</div>
							</div>
						</div>
					</div>
					<div x-show="!isLoading && packages.length === 0">
						<div class="card-body p-0">
							<div class="mt-3 mx-3">
								<?php $this->insert('components/alert', ['type' => 'warning', 'message' => t__('Your shopping cart is empty!')]); ?>
							</div>
						</div>
					</div>
					<div x-show="!isLoading && packages.length > 0">
						<div class="table-responsive">
							<table class="table table-hover">
								<thead>
								<tr>
									<th><?php e__('Product') ?></th>
									<th><?php e__('Price') ?></th>
									<th><?php e__('Quantity') ?></th>
									<th><?php e__('Total') ?></th>
									<th class="text-end">&nbsp;</th>
								</tr>
								</thead>
								<tbody>
								<template x-for="product in packages">
									<tr x-data="tebexStoreCartItem(product)">
										<td class="checkoutItemName">
											<span class="checkoutItemNameText" x-text="product.name"></span>
											<span class="checkoutItemGift" x-show="product.in_basket.gift_username !== null">
												<i class="fa fa-gift" style="margin-left: 2px;" data-bs-toggle="tooltip" data-placement="top" x-bind:title="('<?php echo str_replace("'", "\'", t__('Gift to %username%')) ?>').replace('%username%', product.in_basket.gift_username)"></i>
											</span>
										</td>
										<td class="checkoutItemPrice" x-text="tebexStoreMoney(product.in_basket.price, currency)"></td>
										<td class="checkoutItemQuantity">
											<div class="input-group" style="width: 95px;">
												<button @click="decreaseQuantity()" class="btn btn-sm btn-danger cartItemDecreaseButton" type="button">-</button>
												<input x-show="!isQuantityLoading" type="text" class="form-control form-control-sm text-center px-0 cartItemAmountUpdateInput" x-model="quantity" data-max="0" autocomplete="off" disabled>
												<div x-show="isQuantityLoading" class="checkoutItemQuantitySpinner">
													<div class="spinner-border spinner-border-sm" role="status">
														<span class="sr-only">...</span>
													</div>
												</div>
												<button @click="increaseQuantity()" class="btn btn-sm btn-success cartItemIncreaseButton" type="button">+</button>
											</div>
										</td>
										<td class="checkoutItemTotal" x-text="tebexStoreMoney(product.in_basket.price * quantity, currency)"></td>
										<td class="checkoutItemButtons text-end">
											<a :href="'/store/products/' + product.id" x-bind:disabled="isProductLoading" class="btn btn-primary btn-sm btn-icon openBuyModal" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Details') ?>">
												<i x-show="!isProductLoading" class="fa fa-info"></i>
												<div x-show="isProductLoading" class="removeItemButtonSpinner">
													<div class="spinner-border spinner-border-sm" role="status">
														<span class="sr-only">...</span>
													</div>
												</div>
											</a>
											<button @click="removeItem()" x-bind:disabled="isRemoving" class="btn btn-danger btn-sm btn-icon removeItemButton" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Remove') ?>">
												<i x-show="!isRemoving" class="ti ti-x icon-sm removeItemButtonIcon"></i>
												<div x-show="isRemoving" class="removeItemButtonSpinner">
													<div class="spinner-border spinner-border-sm" role="status">
														<span class="sr-only">...</span>
													</div>
												</div>
											</button>
										</td>
									</tr>
								</template>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-4">
				<?php $this->insert('components/tebex/auth-card'); ?>
				<div class="card">
					<div class="card-header">
						<h2 class="card-title"><?php e__('Order Summary') ?></h2>
					</div>
					<div class="card-body">
						<div id="shoppingCartSummary">
							<div class="row">
								<div class="col-md-12">
									<label for="inputCoupon" class="form-label p-0">
										<?php e__('Redeem Coupons or Gift Cards') ?>
									</label>
									<div class="input-group">
										<input type="text" id="inputCoupon" class="form-control" name="coupon" x-model="code" placeholder="<?php e__('Enter coupon/gift card here') ?>" x-bind:disabled="isLoading">
										<div class="input-group-append">
											<button @click="redeemCode()" type="button" id="addCouponButton" class="btn btn-success" style="border-top-left-radius: 0; border-bottom-left-radius: 0;" x-bind:disabled="isCouponLoading" x-text="isCouponLoading ? '<?php e__('Loading...') ?>' : '<?php e__('Apply') ?>'"></button>
										</div>
									</div>
									<small x-ref="couponMessage" class="text-danger"></small>
									
									<div x-show="coupons.length > 0 || giftCards.length > 0" class="pt-2">
										<template x-for="coupon in coupons">
											<div x-data="{ isRemoving: false }" class="d-flex align-items-center w-100 couponCodesItem">
												<span class="couponCodesItemCode">
													<span class='badge text-white bg-info' style='margin-right: 4px;'><?php e__('Coupon') ?></span>
													<span x-text="coupon.code"></span>
												</span>
												<i x-show="!isRemoving" @click="isRemoving = true; removeCoupon(coupon.code)" class="removeCouponCodesItem fa fa-times text-danger" style="padding-left: 6px; cursor: pointer;"></i>
												<div x-show="isRemoving" class="removeCouponCodesItemSpinner" style="padding-left: 6px;">
													<div class="spinner-border spinner-border-sm" role="status">
														<span class="sr-only">...</span>
													</div>
												</div>
											</div>
										</template>
										<template x-for="giftCard in giftCards">
											<div x-data="{ isRemoving: false }" class="d-flex align-items-center w-100 couponCodesItem">
												<span class="couponCodesItemCode">
													<span class='badge text-white bg-info' style='margin-right: 4px;'><?php e__('Gift Card') ?></span>
													<span x-text="giftCard.card_number"></span>
												</span>
												<i x-show="!isRemoving" @click="isRemoving = true; removeGiftCard(giftCard.card_number)" class="removeCouponCodesItem fa fa-times text-danger" style="padding-left: 6px; cursor: pointer;"></i>
												<div x-show="isRemoving" class="removeCouponCodesItemSpinner" style="padding-left: 6px;">
													<div class="spinner-border spinner-border-sm" role="status">
														<span class="sr-only">...</span>
													</div>
												</div>
											</div>
										</template>
									</div>
								</div>
							</div>
							<div id="discountBlock" class="row pt-4" style="display: none;">
								<div class="col">
									<span class="fw-bold"><?php e__('Discount') ?>:</span>
								</div>
								<div class="col-auto text-end">
									<span id="discount" class="text-danger">
										-
									</span>
								</div>
							</div>
							<div class="row pt-4">
								<div class="col">
									<span class="fw-bold"><?php e__('Total') ?>:</span>
								</div>
								<div class="col-auto text-end">
									<span id="total" class="text-success" x-text="total !== null ? tebexStoreMoney(total, currency) : '-'"></span>
								</div>
							</div>
							<div class="pt-3">
								<a @click="checkout()" id="checkoutButton" class="btn btn-success w-100"><?php e__('Checkout') ?></a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>