<?php $this->layout('layouts/main'); ?>

<?php if ($this->e($theme_mode) == "dark"): ?>
	<link rel="stylesheet" href="<?php echo $this->asset('/css/plugins/skeloading/skeloading-dark.min.css'); ?>">
<?php else: ?>
	<link rel="stylesheet" href="<?php echo $this->asset('/css/plugins/skeloading/skeloading.min.css'); ?>">
<?php endif; ?>

<style>
	[x-cloak] { display: none !important; }
	.tebex-list {
		position: relative;
		overflow: hidden;
		border-bottom-left-radius: 15px;
		border-bottom-right-radius: 15px;
	}
	.tebex-list .expandCategory {
		position: absolute;
		top: 0;
		right: 0;
		padding: 0.75rem 1.25rem;
		cursor: pointer;
	}
	.tebex-list-item {
		position: relative;
		display: flex;
		justify-content: space-between;
		cursor: pointer;
	}
	.tebex-list-item span {
		width: 100%;
		padding: .75rem 1.25rem;
	}
	.tebex-list-subitem {
		display: block;
		padding: .75rem 5.25rem 0.75rem 2rem;
		cursor: pointer;
	}
	.dark .tebex-list-item,
	.dark .tebex-list-subitem {
		color: #fff !important;
	}
	.dark .tebex-list-item i {
		color: #fff !important;
	}
	.tebex-list-item.active,
	.tebex-list-subitem.active {
		background-color: var(--tblr-primary) !important;
		color: #fff !important;
	}
	.tebex-list-item.active i {
		color: #fff !important;
	}
	.tebex-list .subcategories {
		height: 0;
		transform: scaleY(0);
		transform-origin: top;
		transition: transform 0.26s ease;
	}
	.tebex-list .subcategories.active {
		height: auto;
		transform: scaleY(1);
	}
</style>

<script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.13.5/dist/cdn.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/js-cookie@3.0.5/dist/js.cookie.min.js"></script>

<script>
	const tebexCompleteUrl = "<?php echo website_url(url('payment.success')); ?>";
	const tebexCancelUrl = "<?php echo website_url(url('payment.error')); ?>";
</script>
<script src="<?php echo $this->asset('/js/tebex_store.js'); ?>"></script>

<section
	x-cloak
	x-data="tebexStore('<?php echo modules('tebex_store')->settings('publicKey'); ?>', <?php echo htmlentities(json_encode($tierTables)) ?>, <?php echo $category ?? 'null'; ?>)"
	class="section tebex-section"
>
	<div class="container">
		<div class="row">
			<div class="col-md-3">
				<div x-show="isCategoriesLoading || categories.length > 0">
					<div x-show="isCategoriesLoading" class="card p-3 mb-3">
						<div class="d-flex justify-content-between align-items-center">
							<div class="d-flex gap-2">
								<div class="sl sl-image sl-rounded-sm sl-animation-shimmer" style="width: 46px; height: 46px;"></div>
								<div class="ms-2">
									<div class="card-title mb-0">
										<div class="sl sl-title sl-height-xl sl-width-md sl-rounded-sm sl-animation-shimmer"></div>
									</div>
									<div class="text-muted small">
										<div class="sl sl-title sl-height-sm sl-width-sm sl-rounded-sm sl-animation-shimmer"></div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div x-show="!isCategoriesLoading">
						<?php $this->insert('components/tebex/auth-card'); ?>
					</div>
					<div class="card">
						<div class="card-header">
							<h2 class="card-title last-donators"><?php e__('Categories') ?></h2>
						</div>
						<div class="card-body p-0">
							<div class="tebex-list">
								<div x-show="isCategoriesLoading && categories.length === 0">
									<div style="padding: 10px 20px;">
										<div class="sl sl-title sl-height-xl sl-width-full sl-rounded-sm sl-animation-shimmer"></div>
										<div class="sl sl-title sl-height-xl sl-width-full sl-rounded-sm sl-animation-shimmer"></div>
										<div class="sl sl-title sl-height-xl sl-width-full sl-rounded-sm sl-animation-shimmer"></div>
										<div class="sl sl-title sl-height-xl sl-width-full sl-rounded-sm sl-animation-shimmer"></div>
										<div class="sl sl-title sl-height-xl sl-width-full sl-rounded-sm sl-animation-shimmer"></div>
										<div class="sl sl-title sl-height-xl sl-width-full sl-rounded-sm sl-animation-shimmer"></div>
										<div class="sl sl-title sl-height-xl sl-width-full sl-rounded-sm sl-animation-shimmer"></div>
									</div>
								</div>
								<div x-show="categories.length > 0">
									<template x-for="category in categoryListing">
										<div
											x-data="{
			                  isExpanded: false
			                }"
											x-init="isExpanded = categoryData !== null && (categoryData.id === category.id || category.subcategories.find(sc => sc.id === categoryData.id) !== undefined);"
										>
											<div class="tebex-list-item" :class="(categoryData !== null && categoryData.id === category.id) ? 'active' : ''">
												<span @click="changeCategory(category.id); isExpanded = true;" x-text="category.name"></span>
												<template x-if="category.subcategories.length > 0">
													<div class="expandCategory" @click="isExpanded = !isExpanded">
														<i class="fa fa-chevron-down" style="font-size: 12px;"></i>
													</div>
												</template>
											</div>
											<div class="subcategories" :class="((categoryData !== null && categoryData.id === category.id && isExpanded) || isExpanded) ? 'active' : ''">
												<template x-for="subcategory in category.subcategories">
													<a @click="changeCategory(subcategory.id)" class="tebex-list-subitem" :class="categoryData !== null && categoryData.id === subcategory.id ? 'active' : ''">
														<span x-text="subcategory.name"></span>
													</a>
												</template>
											</div>
										</div>
									</template>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div x-show="!isCategoriesLoading && categories.length === 0">
					<div class="col-md-12">
						<div class="alert alert-warning mb-0">
							<?php e__('No category were found!') ?>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-9">
				<div>
					<div x-show="isHomepage && !isStoreLoading" class="card">
						<template x-if="store !== null">
							<div>
								<div class="card-body" x-html="store.description"></div>
							</div>
						</template>
					</div>
					<div x-show="isHomepage && isStoreLoading" class="card">
						<div class="card-body">
							<div class="sl sl-paragraph sl-rounded-sm sl-animation-shimmer"></div>
							<div class="sl sl-paragraph sl-rounded-sm sl-animation-shimmer"></div>
							<div class="sl sl-paragraph sl-rounded-sm sl-animation-shimmer"></div>
							<div class="sl sl-paragraph sl-rounded-sm sl-animation-shimmer"></div>
							<div class="sl sl-paragraph sl-rounded-sm sl-animation-shimmer"></div>
							<div class="sl sl-paragraph sl-rounded-sm sl-animation-shimmer"></div>
							<div class="sl sl-paragraph sl-rounded-sm sl-animation-shimmer"></div>
							<div class="sl sl-paragraph sl-rounded-sm sl-animation-shimmer"></div>
							<div class="sl sl-paragraph sl-rounded-sm sl-animation-shimmer"></div>
						</div>
					</div>
					
					<template x-if="!isHomepage && tierTable === null">
						<div>
							<div x-show="isCategoryLoading" class="card">
								<div class="card-header">
									<div class="sl sl-title sl-rounded-sm sl-animation-shimmer mb-0"></div>
								</div>
								<div class="card-body">
									<div class="row">
										<?php for ($i = 0; $i < 4; $i++): ?>
											<div class="col-md-3 col-sm-6 mb-grid-gutter">
												<div class="sl-card sl-rounded-lg bg-transparent border-0 px-0 py-0">
													<div class="sl sl-image sl-rounded-lg sl-animation-shimmer mb-3" style="width: 100%; height: 180px;"></div>
													<div class="sl sl-title sl-width-sm sl-rounded-sm sl-animation-shimmer"></div>
													<div class="sl sl-input w-full sl-rounded-sm sl-animation-shimmer mt-4"></div>
												</div>
											</div>
										<?php endfor; ?>
									</div>
								</div>
							</div>
							<div x-show="!isCategoryLoading" class="card">
								<div class="card-header d-block">
									<h2 class="card-title" x-text="categoryData !== null ? categoryData.name : 'Not Found!'"></h2>
									<div class="ck-content" x-html="categoryData !== null ? categoryData.description : ''"></div>
								</div>
								<div class="card-body">
									<div x-show="products.length > 0" class="row">
										<template x-for="product in products">
											<div class="col-md-3 col-sm-6 mb-grid-gutter">
												<div class="card card-product border-0">
													<img class="card-img-top" x-bind:src="product.image">
													
													<div class="card-body">
														<h3 class="fs-lg fw-medium my-2" x-text="product.name"></h3>
														<span class="text-heading fw-semibold">
															<template x-if="product.discount > 0">
																<span class="old-price" x-text="tebexStoreMoney(product.base_price + product.discount, product.currency)"></span>
																<small>/</small>
															</template>
															<span class="price" x-text="tebexStoreMoney(product.base_price, product.currency)"></span>
														</span>
														
														<div class="mt-auto">
															<a
																:href="'/store/products/' + product.id"
																class="btn btn-success w-100 stretched-link"
															>
																<i class="shi-shopping-cart me-1"></i>
																<span x-text="product.type === 'subscription' ? '<?php e__('Subscribe') ?>' : '<?php e__('Buy Now') ?>'"></span>
															</a>
														</div>
													</div>
												</div>
											</div>
										</template>
									</div>
									<div x-show="products.length === 0">
										<div class="alert alert-warning mb-0">
											<?php e__('No product were found!') ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</template>
					<template x-if="!isHomepage && tierTable !== null">
						<div>
							<div x-show="isCategoryLoading" class="card">
								<div class="card-header">
									<div class="sl sl-title sl-rounded-sm sl-animation-shimmer mb-0"></div>
								</div>
								<div class="card-body">
									<div class="row">
										<?php for ($i = 0; $i < 4; $i++): ?>
											<div class="col-md-3 col-sm-6 mb-grid-gutter">
												<div class="sl-card sl-rounded-lg bg-transparent border-0 px-0 py-0">
													<div class="sl sl-image sl-rounded-lg sl-animation-shimmer mb-3" style="width: 100%; height: 180px;"></div>
													<div class="sl sl-title sl-width-sm sl-rounded-sm sl-animation-shimmer"></div>
													<div class="sl sl-input w-full sl-rounded-sm sl-animation-shimmer mt-4"></div>
												</div>
											</div>
										<?php endfor; ?>
									</div>
								</div>
							</div>
							<div x-show="!isCategoryLoading" class="card">
								<div class="card-header d-block">
									<h2 class="card-title" x-text="categoryData !== null ? categoryData.name : 'Not Found!'"></h2>
									<div class="ck-content" x-html="categoryData !== null ? categoryData.description : ''"></div>
								</div>
								<div class="table-responsive vip-table">
									<table class="table table-hover mb-0">
										<thead>
										<tr>
											<th scope="col"></th>
											<template x-for="tier in tierTable.tiers" :key="tier">
												<th class="py-4 text-center" style="text-transform: none; font-size: inherit" x-data="{product: null}" x-init="$watch('products', (value) => product = value.find(x => x.id == tier))">
													<template x-if="product !== null && product !== undefined">
														<div class="position-relative d-inline-flex">
															<div class="card-product text-body">
																<img class="store-card-img" :src="product.image" style="max-width: 150px">
																<div class="row store-card-text d-flex flex-column">
																	<span class="d-block h3 mb-2 mt-3" x-text="product.name"></span>
																	<div class="d-block">
																		<span class="text-heading fw-semibold">
																			<template x-if="product.discount > 0">
																				<span class="old-price" x-text="tebexStoreMoney(product.base_price + product.discount, product.currency)"></span>
																				<small>/</small>
																			</template>
																			<span class="price" x-text="tebexStoreMoney(product.base_price, product.currency)"></span>
																		</span>
																	</div>
																</div>
																<div class="store-card-button mt-3">
																	<a
																		:href="'/store/products/' + product.id"
																		class="btn btn-success w-100 stretched-link"
																	>
																		<i class="shi-shopping-cart me-1"></i>
																		<span x-text="product.type === 'subscription' ? '<?php e__('Subscribe') ?>' : '<?php e__('Buy Now') ?>'"></span>
																	</a>
																</div>
															</div>
														</div>
													</template>
												</th>
											</template>
										</tr>
										</thead>
										<tbody>
										<template x-for="title in tierTable.titles" :key="title.id">
											<tr :class="title.descriptions.length === 0 ? 'sep' : ''">
												<template x-if="title.descriptions.length === 0">
													<td :colspan="tierTable.tiers.length + 1" class="text-start table-header" x-text="title.title"></td>
												</template>
												<template x-if="title.descriptions.length > 0">
													<td class="text-start">
														<span x-text="title.title"></span>
														<i x-show="title.explain !== null" class="ti ti-info-circle-filled" data-bs-toggle="tooltip" :title="title.explain"></i>
													</td>
												</template>
												<template x-for="description in (title.descriptions.length > 0 ? title.descriptions : [])">
													<td class="text-center">
														<i x-show="description === '-'" class="ti ti-x text-danger"></i>
														<i x-show="description === '+'" class="ti ti-check text-success"></i>
														<span x-show="description !== '-' && description !== '+'" x-text="description"></span>
													</td>
												</template>
											</tr>
										</template>
										</tbody>
									</table>
								</div>
							</div>
						</div>
					</template>
				</div>
			</div>
		</div>
	</div>
</section>