<?php $this->layout('layouts/main'); ?>

<script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.13.5/dist/cdn.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/js-cookie@3.0.5/dist/js.cookie.min.js"></script>

<script>
	const tebexCompleteUrl = "<?php echo website_url(url('payment.success')); ?>";
	const tebexCancelUrl = "<?php echo website_url(url('payment.error')); ?>";
</script>

<script src="<?php echo $this->asset('/js/tebex_store.js'); ?>"></script>

<section class="section page-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('store.index'),
						"text" => t__("Store")
					],
					[
						"text" => t__("Login")
					],
				]]) ?>
			</div>
			<div class="col-md-12">
				<div class="card">
					<div class="card-header">
						<h2 class="card-title"><?php e__('Login') ?></h2>
					</div>
					<div class="card-body">
						<?php if ($game_type == "minecraft"): ?>
							<div x-cloak x-data="tebexStoreLogin('<?php echo modules('tebex_store')->settings('publicKey'); ?>', <?php echo (get('addCart')) ? "'".get('addCart')."'" : 'null'; ?>)">
								<div class="row g-2">
									<div class="col">
										<input type="text" name="username" class="form-control" placeholder="<?php e__('Enter your in-game username') ?>" x-model="usernameModel" />
									</div>
									<div class="col-auto">
										<button type="button" x-show="!isLoading" @click="login()" class="btn btn-primary">
											<?php e__('Continue') ?>
										</button>
										<button x-show="isLoading" class="btn btn-primary" disabled>
											<?php e__('Loading...') ?>
										</button>
									</div>
								</div>
							</div>
						<?php endif; ?>
						
						<?php if ($game_type != "minecraft"): ?>
							<div x-cloak x-data="tebexStoreExternalLogin('<?php echo modules('tebex_store')->settings('publicKey'); ?>', '<?php echo website_url(url('tebex.auth.callback')) ?>', <?php echo (get('addCart')) ? "'".get('addCart')."'" : 'null'; ?>)">
								<button type="button" @click="login()" x-show="!isLoading" class="btn btn-primary">
									<?php e__('Sign in with %provider%', ['%provider%' => $game_type == 'fivem' ? 'FiveM' : 'Steam']) ?>
								</button>
								<button x-show="isLoading" class="btn btn-primary" disabled>
									<?php e__('Loading...') ?>
								</button>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>