<?php $this->layout('layouts/main') ?>

<?php if ($this->e($theme_mode) == "dark"): ?>
	<link rel="stylesheet" href="<?php echo $this->asset('/css/plugins/skeloading/skeloading-dark.min.css'); ?>">
<?php else: ?>
	<link rel="stylesheet" href="<?php echo $this->asset('/css/plugins/skeloading/skeloading.min.css'); ?>">
<?php endif; ?>

<script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.13.5/dist/cdn.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/js-cookie@3.0.5/dist/js.cookie.min.js"></script>

<script>
	const tebexCompleteUrl = "<?php echo website_url(url('payment.success')); ?>";
	const tebexCancelUrl = "<?php echo website_url(url('payment.error')); ?>";
</script>
<script src="<?php echo $this->asset('/js/tebex_store.js'); ?>"></script>

<section
	x-cloak
	x-data="tebexStore('<?php echo modules('tebex_store')->settings('publicKey'); ?>', null, <?php echo $category ?? 'null'; ?>, <?php echo $product ?? 'null'; ?>, 'page')"
	class="section tebex-section"
>
	<div class="container">
		<div x-show="(productData === null || productData === undefined) && !isProductLoading">
			<div class="alert alert-danger">
				<?php e__('No product were found!') ?>
			</div>
		</div>
		<div x-show="productData === null && isProductLoading">
			<div class="sl sl-input sl-rounded-sm sl-animation-shimmer mb-4"></div>
			<div class="row">
				<div class="col-md-8 mt-2">
					<div class="card">
						<div class="card-body">
							<div class="row">
								<div class="col-md-4">
									<div class="sl sl-image sl-width-full sl-rounded-sm sl-animation-shimmer" style="height: 200px;"></div>
								</div>
								<div class="col-md-8">
									<div class="sl sl-title sl-width-md sl-height-md sl-rounded-sm sl-animation-shimmer"></div>
									<div class="sl sl-title sl-width-lg sl-height-xl sl-rounded-sm sl-animation-shimmer"></div>
									<hr class="my-3">
									<div class="sl sl-paragraph sl-rounded-sm sl-animation-shimmer"></div>
									<div class="sl sl-paragraph sl-rounded-sm sl-animation-shimmer"></div>
									<div class="sl sl-paragraph sl-rounded-sm sl-animation-shimmer"></div>
									<div class="sl sl-paragraph sl-rounded-sm sl-animation-shimmer"></div>
									<div class="sl sl-paragraph sl-rounded-sm sl-animation-shimmer"></div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="col-md-4">
					<div class="card mt-2">
						<div class="card-body">
							<div class="sl sl-title sl-height-xl sl-rounded-sm sl-animation-shimmer"></div>
							<div class="d-flex justify-content-between">
								<div class="sl sl-title sl-width-sm sl-height-sm sl-rounded-sm sl-animation-shimmer mt-4"></div>
								<div class="sl sl-title sl-width-xs sl-height-sm sl-rounded-sm sl-animation-shimmer mt-4"></div>
							</div>
							<div class="d-flex justify-content-between">
								<div class="sl sl-title sl-width-sm sl-height-sm sl-rounded-sm sl-animation-shimmer"></div>
								<div class="sl sl-title sl-width-xs sl-height-sm sl-rounded-sm sl-animation-shimmer"></div>
							</div>
							<div class="d-flex justify-content-between">
								<div class="sl sl-title sl-width-sm sl-height-sm sl-rounded-sm sl-animation-shimmer"></div>
								<div class="sl sl-title sl-width-xs sl-height-sm sl-rounded-sm sl-animation-shimmer"></div>
							</div>
							<div class="sl sl-button sl-height-xl sl-rounded-sm sl-animation-shimmer mt-4" style="height: 40px!important;"></div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<template x-if="productData !== null && productData !== undefined">
			<div x-data="tebexStoreProductUI(productData, 'page')">
				<div class="row">
					<div class="col-md-12">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb">
								<li class="breadcrumb-item"><a href="/"><?php e__('Home') ?></a></li>
								<li class="breadcrumb-item"><a href="<?php echo url('store.index') ?>"><?php e__('Store') ?></a></li>
								<li class="breadcrumb-item"><a x-bind:href="'/store/' + productData.category.id" x-text="productData.category.name"></a></li>
								<li class="breadcrumb-item active" aria-current="page" x-text="productData.name"></li>
							</ol>
						</nav>
					</div>
					<div class="col-md-8">
						<div class="card">
							<div class="card-body py-4">
								<div class="row" x-show="productData.image !== null">
									<div class="col-md-4">
										<img :src="productData.image" alt="" class="lazyload w-100 mb-2">
									</div>
									<div class="col-md-8">
										<div>
											<p class="mb-0 opacity-75 small text-uppercase fw-semibold" x-text="productData.category.name"></p>
											<h2 class="h2 mb-0" x-text="productData.name"></h2>
										</div>
										<hr class="my-3">
										<div class="ck-content mt-3" x-html="productData.description"></div>
									</div>
								</div>
								<div class="row" x-show="productData.image === null">
									<div class="col-md-12">
										<div>
											<p class="mb-0 opacity-75 small text-uppercase fw-semibold" x-text="productData.category.name"></p>
											<h2 class="h2 mb-0" x-text="productData.name"></h2>
										</div>
										<hr class="my-3">
										<div class="ck-content mt-3" x-html="productData.description"></div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-md-4">
						<div class="card">
							<div class="card-header">
								<h2 class="card-title fs-100"><?php e__('Order Summary') ?></h2>
							</div>
							<div class="card-body">
								<div class="row" x-show="productData.discount > 0">
									<div class="col align-items-center">
										<span class="form-label"><?php e__('Discount') ?>:</span>
									</div>
									<div class="col-auto text-end">
										<span class="text-danger" x-text="tebexStoreMoney(productData.discount, productData.currency)"></span>
									</div>
								</div>
								
								<div class="row">
									<div class="col align-items-center">
										<span class="form-label mb-0"><?php e__('Subtotal') ?>:</span>
									</div>
									<div class="col-auto text-end">
										<span x-text="tebexStoreMoney(productData.base_price, productData.currency)"></span>
									</div>
								</div>
								
								<div class="row">
									<div class="col align-items-center">
										<span class="form-label mb-0"><?php e__('Tax') ?>:</span>
									</div>
									<div class="col-auto text-end">
										<span x-text="tebexStoreMoney(productData.sales_tax, productData.currency)"></span>
									</div>
								</div>
								
								<div class="row">
									<div class="col align-items-center">
										<span class="form-label mb-0"><?php e__('Total') ?>:</span>
									</div>
									<div class="col-auto text-end">
										<span class="text-success fw-bold fs-3" x-text="tebexStoreMoney(productData.total_price, productData.currency)"></span>
									</div>
								</div>
								
								<div class="pt-4">
									<button
										type="button"
										class="btn btn-success w-100"
										@click="addToCart()" x-show="!buttonLoading" x-text="productData.type === 'subscription' ? '<?php e__('Subscribe') ?>' : '<?php e__('Add to Cart') ?>'"
									></button>
									<button x-show="buttonLoading" class="btn btn-success w-100" disabled>
										<?php e__('Loading...') ?>
									</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</template>
	</div>
</section>