<?php $this->layout('layouts/auth'); ?>

<?php _message(); ?>
<div class="card card-md">
	<div class="card-body">
		<h2 class="h2 text-center mb-1"><?php e__('Two Factor Authentication') ?></h2>
		<p class="text-muted mb-5 text-center">
			<?php e__('Scan the QR code with the Google Authenticator app.') ?>
		</p>
		<form data-toggle="form-submit-with-loader" action="<?php echo url('tfa.setup.action') ?>" method="post">
			<?php _csrf(); ?>
			<div class="mb-3 text-center">
				<img src="<?php echo $qrCode; ?>" alt="Google Authenticator QR">
			</div>
			<div class="mb-5 text-center">
				<?php e__('If you cannot read the QR code, add an account with the <strong>%key%</strong> key.', ['%key%' => $secretKey]) ?>
			</div>
			<div class="mb-3">
				<label for="code" class="form-label"><?php e__('Code') ?></label>
				<input type="number" name="code" id="code" class="form-control" autocomplete="off" required>
			</div>
			<div class="form-footer mt-4">
				<button type="submit" class="btn btn-primary w-100">
					<?php e__('Verify') ?>
				</button>
			</div>
		</form>
	</div>
</div>