<?php $this->layout('layouts/auth'); ?>

<?php if (recaptcha()->isEnabled('tfa')) : ?>
	<?php $this->push('head'); ?>
	<?php echo recaptcha()->getScript(); ?>
	<?php $this->end(); ?>
<?php endif; ?>

<?php _message(); ?>
<div class="card card-md">
	<div class="card-body">
		<h2 class="h2 text-center mb-1"><?php e__('Two Factor Authentication') ?></h2>
		<p class="text-muted mb-5 text-center">
			<?php e__('Enter the code from the application.') ?>
		</p>
		<form data-toggle="form-submit-with-loader" action="<?php echo url('tfa.verify') ?>" method="post">
			<?php _csrf(); ?>
			<div class="mb-3">
				<label for="code" class="form-label"><?php e__('Code') ?></label>
				<input type="number" name="code" id="code" class="form-control" autocomplete="off" required>
			</div>
			<?php if (recaptcha()->isEnabled('tfa')) : ?>
				<div class="mt-3 d-flex justify-content-center">
					<?php echo recaptcha()->getHTML() ?>
				</div>
			<?php endif; ?>
			<div class="form-footer mt-4">
				<button type="submit" class="btn btn-primary w-100">
					<?php e__('Verify') ?>
				</button>
			</div>
		</form>
	</div>
</div>
<a class="d-block text-center text-secondary mt-3" href="<?php echo url('tfa.recover.index') ?>">
	<?php e__("I don't have access!") ?>
</a>