<?php $this->layout('layouts/main'); ?>
<?php if (recaptcha()->isEnabled('open_ticket')) : ?>
	<?php $this->push('head'); ?>
	<?php echo recaptcha()->getScript(); ?>
	<?php $this->end(); ?>
<?php endif; ?>
<?php $this->push('scripts'); ?>
<script src="<?php echo $this->asset('/js/plugins/ckeditor/ckeditor.js') ?>"></script>
<script src="<?php echo $this->asset('/js/ckeditor5.js') ?>"></script>
<script src="<?php echo $this->asset('/js/support.js') ?>"></script>
<script src="<?php echo $this->asset('/js/support.open.js') ?>"></script>
<?php $this->end(); ?>

<section class="section support-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('support.tickets.index'),
						"text" => t__('Support')
					],
					[
						"text" => t__('Open Ticket')
					]
				]]) ?>
			</div>
			<div class="col-md-12">
				<?php _message(); ?>
				<div class="card">
					<div class="card-header">
						<h2 class="card-title"><?php e__('Open Ticket') ?></h2>
					</div>
					<div class="card-body">
						<form data-toggle="form-submit-with-loader" action="<?php echo url('support.tickets.store') ?>" method="post">
							<?php _csrf(); ?>
							
							<label for="inputTitle" class="form-label px-0"><?php e__('Title') ?>:</label>
							<div class="mb-3">
								<input type="text" id="inputTitle" class="form-control" name="title" placeholder="<?php e__('Enter a title.') ?>" value="<?php _old('title') ?>">
							</div>
							
							<label for="selectCategory" class="form-label px-0"><?php e__('Category') ?>:</label>
							<div class="mb-3">
								<select id="selectCategory" class="form-control" name="categoryID" data-toggle="select2" <?php echo (count($categories) == 0) ? "disabled" : null; ?>>
									<?php if (count($categories) > 0): ?>
										<option disabled selected><?php e__('Select category.') ?></option>
										<?php foreach ($categories as $category): ?>
											<option value="<?php echo $category["id"]; ?>"><?php echo $category["name"]; ?></option>
										<?php endforeach; ?>
									<?php else: ?>
										<option><?php e__('No category were found!') ?></option>
									<?php endif; ?>
								</select>
							</div>
							
							<div id="custom-support-fields">
								<?php foreach ($categories as $category): ?>
									<div id="category-<?php echo $category["id"] ?>" style="display: none;">
										<?php foreach ($category["fields"] as $field): ?>
											<div class="mb-3">
												<label for="input-<?php echo $field["id"]; ?>" class="form-label px-0">
													<?php echo $field["field"]; ?>:
												</label>
												<?php if ($field["type"] == 1): ?>
													<input type="text" id="input-<?php echo $field["id"]; ?>" class="form-control" name="field-<?php echo $field["id"]; ?>">
												<?php endif; ?>
												<?php if ($field["type"] == 2): ?>
													<textarea id="input-<?php echo $field["id"]; ?>" class="form-control" name="field-<?php echo $field["id"]; ?>" rows="3"></textarea>
												<?php endif; ?>
												<?php if ($field["type"] == 3 || $field["type"] == 4): ?>
													<select id="input-<?php echo $field["id"]; ?>" class="form-control" name="field-<?php echo $field["id"].($field["type"] == 4 ? "[]" : null); ?>" <?php echo ($field["type"] == 4) ? 'multiple="multiple"' : null ?>>
														<?php $variables = explode(",", $field["variables"]); ?>
														<?php foreach ($variables as $variable): ?>
															<?php $variable = trim($variable); ?>
															<?php if ($variable != ''): ?>
																<option value="<?php echo $variable; ?>"><?php echo $variable; ?></option>
															<?php endif; ?>
														<?php endforeach; ?>
													</select>
												<?php endif; ?>
											</div>
										<?php endforeach; ?>
									</div>
								<?php endforeach; ?>
							</div>
							
							<label for="textareaMessage" class="form-label px-0"><?php e__('Message') ?>:</label>
							<div class="mb-3">
								<textarea
									id="ckeditor"
									name="message"
									placeholder="<?php e__('Type the message you want to forward to our support team.') ?>"
									class="form-control"
									rows="6"
									data-upload="<?php echo url('support.tickets.upload') ?>"
									data-csrf="<?php echo csrf_token(); ?>"><?php _old('message') ?></textarea>
							</div>
							
							<?php if (recaptcha()->isEnabled('open_ticket')) : ?>
								<div class="mb-3 d-flex justify-content-end">
									<?php echo recaptcha()->getHTML() ?>
								</div>
							<?php endif; ?>
							<div class="clearfix">
								<div class="float-end">
									<button type="submit" class="btn btn-primary"><?php e__('Send') ?></button>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>