<?php $this->layout('layouts/main'); ?>

<section class="section support-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('support.tickets.index'),
						"text" => t__('Support')
					],
					[
						"text" => t__('Tickets')
					]
				]]) ?>
			</div>
			<div class="col-md-12">
				<?php _message(); ?>
				<div class="card">
					<div class="card-header justify-content-between py-2">
						<h2 class="card-title"><?php e__('Tickets') ?></h2>
						<a class="btn btn-primary" href="<?php echo url('support.tickets.create') ?>"><?php e__('Open Ticket') ?></a>
					</div>
					<?php if (count($tickets) > 0): ?>
						<div class="card-body p-0">
						<div class="table-responsive">
							<table class="table table-hover">
								<thead>
								<tr>
									<th class="text-center" style="width: 40px;">#ID</th>
									<th><?php e__('Title') ?></th>
									<th><?php e__('Category') ?></th>
									<th><?php e__('Last Updated') ?></th>
									<th class="text-center"><?php e__('Status') ?></th>
									<th class="text-center"> </th>
								</tr>
								</thead>
								<tbody>
								<?php foreach ($tickets as $ticket): ?>
									<tr>
										<td class="text-center" style="width: 40px;">
											<a href="<?php echo url('support.tickets.show', ['id' => $ticket["id"]]); ?>">
												#<?php echo $ticket["id"]; ?>
											</a>
										</td>
										<td>
											<a href="<?php echo url('support.tickets.show', ['id' => $ticket["id"]]); ?>">
												<?php echo $ticket["title"]; ?>
											</a>
										</td>
										<td><?php echo $ticket["categoryName"]; ?></td>
										<td><?php echo carbon($ticket["updateDate"])->diffForHumans(); ?></td>
										<td class="text-center">
											<?php if ($ticket["statusID"] == 1): ?>
												<span class="badge text-white bg-info"><?php e__('Open') ?></span>
											<?php elseif ($ticket["statusID"] == 2): ?>
												<span class="badge text-white bg-success"><?php e__('Answered') ?></span>
											<?php elseif ($ticket["statusID"] == 3): ?>
												<span class="badge text-white bg-warning"><?php e__('User-Reply') ?></span>
											<?php elseif ($ticket["statusID"] == 4): ?>
												<span class="badge text-white bg-danger"><?php e__('Closed') ?></span>
											<?php else: ?>
												<span class="badge text-white bg-danger"><?php e__('Error!') ?></span>
											<?php endif; ?>
										</td>
										<td class="d-flex justify-content-end gap-1">
											<a class="btn btn-primary btn-icon btn-sm" href="<?php echo url('support.tickets.show', ['id' => $ticket["id"]]); ?>" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('View') ?>">
												<i class="ti ti-eye"></i>
											</a>
											<form data-toggle="form-submit-with-loader" action="<?php echo url('support.tickets.close', ['id' => $ticket["id"]]); ?>" method="post">
												<?php _csrf(); ?>
												<button type="submit" class="btn btn-danger btn-icon btn-sm clickdelete" data-bs-toggle="tooltip" data-placement="top" title="<?php e__('Close') ?>">
													<i class="ti ti-x"></i>
												</button>
											</form>
										</td>
									</tr>
								<?php endforeach; ?>
								</tbody>
							</table>
						</div>
					</div>
					<?php else: ?>
						<div class="card-body d-flex flex-column align-items-center justify-content-center">
							<svg class="img" xmlns="http://www.w3.org/2000/svg" height="256" fill="none" viewBox="0 0 800 600">
								<style>
									:where(.theme-dark, [data-bs-theme="dark"]) .tblr-illustrations-not-found-a { fill: #1A2030; } :where(.theme-dark, [data-bs-theme="dark"]) .tblr-illustrations-not-found-b { fill: black; opacity: 0.07; } :where(.theme-dark, [data-bs-theme="dark"]) .tblr-illustrations-not-found-c { fill: #454C5E; } :where(.theme-dark, [data-bs-theme="dark"]) .tblr-illustrations-not-found-d { fill: #232B41; }
									@media (prefers-color-scheme: dark) { .tblr-illustrations-not-found-a { fill: #1A2030; } .tblr-illustrations-not-found-b { fill: black; opacity: 0.07; } .tblr-illustrations-not-found-c { fill: #454C5E; } .tblr-illustrations-not-found-d { fill: #232B41; } }
								</style>
								<path d="M649.951 544.225C649.951 547.416 541.744 550 408.158 550C274.571 550 166.365 547.416 166.365 544.225C166.365 541.034 274.571 538.45 408.158 538.45C541.744 538.45 649.951 541.034 649.951 544.225Z" fill="#A6A9B3" class="tblr-illustrations-not-found-a"></path>
								<path d="M146 285.714C146 327.964 190.681 358.511 210.286 392.553C230.65 427.66 235.514 481.459 270.62 501.672C304.663 521.429 353.143 499.392 395.392 499.392C437.641 499.392 486.122 521.429 520.164 501.672C555.271 481.307 560.134 427.66 580.499 392.553C600.255 358.511 644.784 327.812 644.784 285.714C644.784 243.617 600.103 212.918 580.499 178.875C560.286 143.769 555.271 89.9697 520.164 69.7569C486.122 50.0001 437.641 72.0366 395.392 72.0366C353.143 72.0366 304.663 50.0001 270.62 69.7569C235.514 90.1217 230.65 143.769 210.286 178.875C190.529 212.918 146 243.617 146 285.714Z" fill="#F7F8FC" class="tblr-illustrations-not-found-b"></path>
								<path d="M528.979 234.499L523.508 262.614H459.982L465.301 235.562L459.982 234.499L399.496 541.945L404.815 543.009L410.438 514.286H473.964L468.493 541.945L473.812 543.009L534.298 235.41L528.979 234.499ZM522.444 267.933L511.35 324.164H447.824L458.918 267.933H522.444ZM435.666 385.714L446.76 329.483H510.286L499.192 385.714H435.666ZM498.28 391.185L487.186 447.416H423.66L434.754 391.185H498.28ZM411.502 508.967L422.596 452.736H486.122L475.027 508.967H411.502Z" fill="#232B41" class="tblr-illustrations-not-found-c"></path>
								<path d="M578.523 458.663L569.404 411.854L534.45 234.346L528.979 235.41L534.298 262.31H470.924L465.453 234.346L459.982 235.41L520.468 543.009L525.939 541.945L520.468 514.438H583.842L589.465 543.009L594.936 541.945L578.523 458.663ZM471.988 268.085H535.362L546.304 324.164H482.93L471.988 268.085ZM484.146 329.635H547.52L558.462 385.714H495.088L484.146 329.635ZM496.304 391.337H559.678L565.453 420.517L570.772 447.264H507.246L496.304 391.337ZM519.404 508.966L508.462 452.887H571.836L572.14 454.407L572.748 457.599L582.778 508.966H519.404Z" fill="#A7AAB3"></path>
								<path d="M578.523 458.663L572.596 457.599L571.988 454.407L571.684 452.888H546.608C547.976 450.456 550.103 448.48 552.687 447.264H570.468L565.149 420.517L569.1 412.006L578.523 458.663Z" fill="black" opacity="0.22"></path>
								<path d="M266.669 53.7994H550.103C559.222 53.7994 566.517 61.0943 566.517 70.2128V232.371C566.517 241.489 559.222 248.784 550.103 248.784H266.669C257.55 248.784 250.255 241.489 250.255 232.371V70.3648C250.255 61.2462 257.55 53.7994 266.669 53.7994Z" fill="white" class="tblr-illustrations-not-found-d"></path>
								<path d="M550.103 50H266.668C255.422 50 246.304 59.1185 246.304 70.3647V232.523C246.304 243.769 255.422 252.888 266.668 252.888H550.103C561.349 252.888 570.468 243.769 570.468 232.523V70.3647C570.468 59.1185 561.349 50 550.103 50ZM562.717 232.371C562.717 237.234 559.83 241.793 555.422 243.769C553.751 244.529 551.927 244.985 550.103 244.985H266.668C259.678 244.985 254.054 239.362 254.054 232.371V70.3647C254.054 63.3739 259.678 57.7508 266.668 57.7508H550.103C557.094 57.7508 562.717 63.3739 562.717 70.3647V232.371Z" fill="#232B41" class="tblr-illustrations-not-found-c"></path>
								<path d="M525.939 252.888H474.268C471.228 250.608 468.493 248.024 465.909 245.137C465.605 244.833 465.301 244.377 464.997 244.073C459.678 238.146 456.182 230.851 454.815 223.1C454.663 222.492 454.663 221.733 454.511 221.277C455.423 217.781 458.614 215.198 462.11 215.046C464.389 215.198 466.517 216.261 467.885 218.085C470.164 222.644 473.052 226.748 476.547 230.243C481.41 235.106 486.426 237.994 493.265 241.034C503.751 245.897 514.693 249.848 525.939 252.888Z" fill="black" opacity="0.19"></path>
								<path d="M313.021 117.477L292.504 92.7052H281.714V139.21H294.632V114.438L315.149 139.21H325.939V92.7052H313.021V117.477ZM377.155 98.6322C374.723 96.5046 371.988 94.6809 368.948 93.617C362.261 91.1854 355.118 91.1854 348.431 93.617C342.352 95.7447 337.337 100.456 334.754 106.383C333.386 109.423 332.778 112.614 332.778 115.957C332.778 119.301 333.386 122.492 334.754 125.532C335.969 128.419 337.793 131.003 340.225 133.283C342.656 135.562 345.392 137.234 348.431 138.298C355.118 140.73 362.261 140.73 368.948 138.298C371.988 137.234 374.723 135.41 377.155 133.283C379.434 131.155 381.258 128.571 382.626 125.684C383.994 122.644 384.602 119.301 384.602 115.957C384.602 112.614 383.994 109.423 382.626 106.383C381.258 103.343 379.434 100.76 377.155 98.6322ZM370.316 121.429C369.708 122.948 368.796 124.468 367.58 125.684C366.517 126.9 365.149 127.812 363.629 128.419C360.437 129.635 356.942 129.635 353.751 128.419C352.231 127.812 350.863 126.9 349.799 125.684C348.583 124.468 347.672 123.1 347.064 121.429C345.848 117.933 345.848 113.982 347.064 110.486C347.672 108.967 348.583 107.447 349.799 106.231C350.863 105.015 352.383 104.103 353.751 103.495C356.942 102.28 360.437 102.28 363.629 103.495C365.149 104.103 366.517 105.015 367.58 106.231C368.796 107.447 369.556 108.815 370.316 110.486C371.532 113.982 371.532 117.933 370.316 121.429ZM386.425 92.7052V103.192H400.711V139.21H413.781V103.192H428.067V92.7052H386.425Z" fill="#0455A4" style="fill: #0455A4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455A4));"></path>
								<path d="M281.714 201.976H294.936V186.018H315.301V175.836H294.936V165.806H318.188V155.471H281.714V201.976ZM365.909 161.398C363.477 159.119 360.741 157.447 357.702 156.383C351.015 153.951 343.72 153.951 337.033 156.383C330.954 158.663 326.091 163.222 323.507 169.149C322.14 172.188 321.532 175.38 321.532 178.723C321.532 182.067 322.14 185.41 323.507 188.45C326.091 194.377 331.106 199.088 337.185 201.216C343.872 203.647 351.167 203.647 357.702 201.216C360.741 200.152 363.477 198.328 365.909 196.201C368.188 194.073 370.012 191.489 371.38 188.45C372.748 185.41 373.355 182.067 373.355 178.723C373.355 172.188 370.62 165.957 365.909 161.398ZM358.918 184.195C358.31 185.714 357.398 187.234 356.182 188.45C355.118 189.666 353.751 190.578 352.231 191.185C349.039 192.401 345.544 192.401 342.352 191.185C340.833 190.578 339.465 189.666 338.401 188.45C337.185 187.234 336.273 185.866 335.817 184.195C334.602 180.699 334.602 176.748 335.817 173.252C336.425 171.733 337.337 170.213 338.401 168.997C339.617 167.781 340.985 166.869 342.352 166.261C345.544 165.046 349.039 165.046 352.231 166.261C353.751 166.869 355.118 167.781 356.182 168.997C357.398 170.213 358.31 171.581 358.918 173.252C360.286 176.748 360.286 180.699 358.918 184.195ZM410.437 181.003C410.437 184.954 409.678 187.842 408.158 189.514C406.486 191.337 404.206 192.249 401.775 192.097C399.343 192.249 397.064 191.337 395.392 189.514C393.872 187.842 393.112 184.954 393.112 181.003V155.623H380.042V181.459C380.042 188.298 382.018 193.617 385.817 197.416C389.617 201.216 394.936 203.04 401.927 203.04C408.766 203.04 414.085 201.216 417.884 197.416C421.684 193.617 423.659 188.298 423.659 181.459V155.623H410.589L410.437 181.003ZM463.629 180.243L443.264 155.471H432.322V201.976H445.24V177.204L456.334 190.578L465.757 201.976H476.547V155.471H463.629V180.243ZM530.498 166.413C528.219 162.918 525.179 160.182 521.38 158.359C517.124 156.383 512.565 155.471 507.854 155.471H485.817V201.976H507.854C512.565 202.128 517.124 201.064 521.38 199.088C525.179 197.264 528.219 194.529 530.498 191.033C532.778 187.386 533.994 182.979 533.842 178.723C533.994 174.316 532.778 170.061 530.498 166.413ZM518.796 185.562C517.732 187.386 516.213 189.058 514.237 189.97C512.109 191.033 509.678 191.489 507.246 191.489H499.039V165.957H507.246C509.678 165.957 512.109 166.413 514.237 167.477C516.213 168.389 517.732 169.909 518.796 171.885C521.076 176.14 521.076 181.307 518.796 185.562Z" fill="#A7AAB3"></path>
								<path d="M476.547 190.577V202.127H465.757L456.334 190.729C458.766 188.298 461.958 186.93 465.301 186.626H467.733C471.076 186.778 474.116 188.146 476.547 190.577Z" fill="black" opacity="0.1"></path>
								<path d="M177.307 319.757C174.116 322.645 166.669 320.365 165.909 317.021C165.757 316.413 165.605 315.198 167.277 313.07C166.365 313.222 161.198 314.286 157.702 311.398C157.398 311.246 157.246 310.942 157.094 310.79C156.486 310.182 155.727 309.423 155.879 308.663C156.486 305.471 170.468 301.672 176.243 308.207C176.851 308.967 177.307 309.727 177.763 310.638C179.283 313.526 179.587 317.629 177.307 319.757Z" fill="#FFCB9D" style="fill: #FFCB9D; fill: var(--tblr-illustrations-skin, #FFCB9D);"></path>
								<path d="M177.307 319.757C174.116 322.644 166.669 320.365 165.909 317.021C165.757 316.413 165.605 315.197 167.277 313.07C166.365 313.222 161.198 314.286 157.702 311.398C161.502 310.182 165.453 309.726 169.556 309.726C172.292 309.726 175.027 310.03 177.763 310.486C179.283 313.526 179.587 317.629 177.307 319.757Z" fill="black" opacity="0.1"></path>
								<path d="M292.353 319.757C295.544 322.645 302.991 320.365 303.751 317.021C303.903 316.413 304.055 315.198 302.383 313.07C303.295 313.222 308.462 314.286 311.957 311.398C312.261 311.246 312.413 310.942 312.565 310.79C313.173 310.182 313.933 309.423 313.781 308.663C313.173 305.471 299.191 301.672 293.416 308.207C292.808 308.967 292.353 309.727 291.897 310.638C290.377 313.526 290.073 317.629 292.353 319.757Z" fill="#FFCB9D" style="fill: #FFCB9D; fill: var(--tblr-illustrations-skin, #FFCB9D);"></path>
								<path d="M292.353 319.757C295.544 322.644 302.991 320.365 303.751 317.021C303.903 316.413 304.055 315.197 302.383 313.07C303.295 313.222 308.462 314.286 311.957 311.398C308.158 310.182 304.207 309.726 300.103 309.726C297.368 309.726 294.632 310.03 291.897 310.486C290.377 313.526 290.073 317.629 292.353 319.757Z" fill="black" opacity="0.1"></path>
								<path d="M270.772 329.027L268.948 349.544C268.036 359.271 267.277 368.997 266.365 378.724L265.453 389.21L264.845 396.961L262.869 420.061H210.438L208.158 396.809C207.854 394.377 207.702 391.793 207.398 389.21C207.094 385.258 206.638 381.459 206.182 377.508L205.574 371.733C204.207 357.447 202.687 343.161 201.319 328.875L270.772 329.027Z" fill="#0455A4" style="fill: #0455A4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455A4));"></path>
								<path d="M210.286 420.061L214.845 529.331H223.659L235.97 444.985L244.48 529.331H251.015L262.869 420.061H210.286Z" fill="#DADBE0"></path>
								<path d="M244.48 529.331L235.969 444.985L239.769 420.061H262.869L251.015 529.331H244.48Z" fill="black" opacity="0.15"></path>
								<path d="M217.58 328.268C217.58 328.268 224.723 328.571 227.611 324.316L245.392 323.1C245.392 323.1 250.711 332.067 255.878 332.371C261.045 332.675 241.593 335.106 241.593 335.106L217.428 332.371L217.58 328.268Z" fill="#0455A4" style="fill: #0455A4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455A4));"></path>
								<path d="M209.83 289.666C211.046 292.097 212.869 295.745 215.149 300L216.365 302.128C219.1 306.839 222.444 311.094 226.243 315.046C227.003 315.805 227.763 316.565 228.523 317.173C231.41 319.605 244.784 318.237 254.511 312.766C264.237 307.295 263.477 295.745 257.246 293.465C254.967 292.401 252.991 291.033 251.167 289.21C248.736 286.93 246.456 284.498 244.328 281.763C243.113 280.243 242.353 279.331 242.353 279.331L231.41 275.988L212.261 284.346C213.933 287.538 213.933 290.122 213.021 290.729C212.109 291.337 210.134 289.818 209.83 289.666Z" fill="#FFCB9D" style="fill: #FFCB9D; fill: var(--tblr-illustrations-skin, #FFCB9D);"></path>
								<path d="M209.83 289.666C211.046 292.097 212.869 295.745 215.149 300L216.365 302.128C219.1 306.839 222.444 311.094 226.243 315.046C227.307 314.134 228.219 312.918 228.827 311.702C229.587 310.334 229.891 308.815 230.043 307.295C230.043 305.623 229.891 303.951 229.435 302.432C229.131 301.368 228.979 300.456 228.523 299.392C236.882 298.632 244.784 295.137 251.015 289.362C248.584 287.082 246.304 284.65 244.176 282.067C242.961 280.547 242.201 279.635 242.201 279.635L231.258 276.292L212.109 284.65C213.781 287.842 213.781 290.425 212.869 291.033C211.957 291.641 210.134 289.818 209.83 289.666Z" fill="black" opacity="0.1"></path>
								<path d="M251.319 273.252C252.991 271.58 254.055 269.301 254.055 266.565C254.055 261.398 249.951 257.295 244.784 257.295C240.681 257.295 237.185 260.03 235.97 263.678C234.754 259.878 231.258 257.295 227.155 257.295C222.444 257.295 218.492 260.942 218.036 265.501C216.669 264.59 214.997 264.134 213.173 264.134C208.006 264.134 203.903 268.237 203.903 273.404C203.903 275.38 204.511 277.203 205.574 278.723C202.839 279.787 200.711 282.371 200.711 285.562C200.711 289.666 204.055 292.857 208.006 292.857H208.158C208.31 293.465 208.462 293.921 208.766 294.529C210.59 298.48 213.781 301.52 217.884 303.191C218.644 303.343 219.404 303.647 220.164 303.951C222.14 305.015 223.963 306.535 225.179 308.51C225.635 306.991 225.635 305.471 225.179 304.103C224.115 301.976 222.9 299.848 221.532 297.872L221.38 297.568C221.228 297.264 221.076 297.112 220.924 296.656C220.468 295.745 220.012 294.681 219.556 293.617V293.465C225.635 294.225 242.656 295.441 248.887 284.346C249.799 282.675 250.559 280.699 251.015 278.875C251.015 278.723 251.167 278.571 251.167 278.419C251.319 277.963 251.319 277.355 251.319 276.9V276.748C251.775 275.836 251.775 274.468 251.319 273.252Z" fill="#232B41" class="tblr-illustrations-not-found-c"></path>
								<path d="M218.645 383.739C217.885 389.818 213.781 394.833 208.006 396.809C207.702 394.377 207.55 391.793 207.246 389.21C206.942 385.258 206.486 381.459 206.031 377.508L218.493 340.426C218.644 340.578 220.772 368.845 218.645 383.739ZM266.365 378.723L265.453 389.21L264.845 396.961C258.766 395.137 254.359 389.97 253.599 383.587C251.471 368.693 253.599 340.426 253.599 340.426L266.365 378.723Z" fill="black" opacity="0.1"></path>
								<path d="M223.204 328.875C217.733 352.735 211.198 381.307 211.198 381.307C210.742 382.371 210.134 383.587 209.374 384.498C208.006 386.17 206.486 387.69 204.815 389.058C203.599 390.273 202.079 391.033 200.407 391.641C196 392.705 190.073 386.626 184.754 378.571C182.018 374.316 179.587 369.909 177.611 365.349C173.508 356.079 173.964 352.887 167.733 333.283C165.301 325.684 163.173 319.605 161.654 315.349L189.313 314.286C189.617 316.413 190.073 319.301 190.529 322.644C192.201 334.802 193.416 346.201 194.024 353.495V348.936C194.176 345.593 194.48 342.401 195.088 339.21C196.152 333.891 199.04 319.757 206.79 318.085C212.413 317.173 218.796 321.884 223.204 328.875ZM311.046 315.501C309.526 319.605 307.398 325.836 304.967 333.435C298.736 353.039 299.192 356.231 295.088 365.501C292.809 370.669 290.073 375.532 287.033 380.091C282.018 387.538 276.395 392.857 272.292 391.793C270.468 391.185 268.796 390.122 267.277 388.754C265.909 387.538 264.541 386.17 263.325 384.65C262.717 383.587 262.109 382.523 261.654 381.459L249.647 329.027C250.711 326.748 254.815 318.389 260.894 317.933C268.948 317.477 275.635 331.003 277.459 339.362C278.067 342.553 278.371 345.897 278.523 349.088V353.647C279.131 346.353 280.347 334.954 282.018 322.796C282.474 319.301 282.93 316.413 283.234 314.438L311.046 315.501Z" fill="#0455A4" style="fill: #0455A4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455A4));"></path>
								<path d="M570.468 175.836V242.249C569.404 243.161 568.036 243.921 566.669 244.377L566.365 244.529C562.717 245.745 558.918 245.897 555.271 244.681L555.422 243.769C559.83 241.641 562.717 237.234 562.717 232.371V171.428C563.021 171.428 563.325 171.58 563.629 171.58C566.365 172.34 568.644 173.86 570.468 175.836Z" fill="black" opacity="0.15"></path>
								<path d="M627.915 358.207L627.003 353.191L624.115 338.298L620.468 339.058L604.055 342.249L601.015 342.857L603.903 357.751L604.815 362.766L605.118 364.742L628.219 360.182L627.915 358.207ZM619.556 342.249L621.684 341.793L623.963 353.799L624.723 357.751L607.398 361.094L606.638 357.143L604.359 345.137H604.511L619.556 342.249Z" fill="#DADBE0"></path>
								<path d="M627.915 358.207L627.003 353.191L624.115 338.298L620.468 339.058L604.055 342.249L601.015 342.857L603.903 357.751L604.815 362.766L605.118 364.742L628.219 360.182L627.915 358.207ZM619.556 342.249L621.684 341.793L623.963 353.799L624.723 357.751L607.398 361.094L606.638 357.143L604.359 345.137H604.511L619.556 342.249Z" fill="black" opacity="0.35"></path>
								<path d="M654.207 385.258L648.128 354.255L647.216 349.24L637.337 351.064L638.249 355.927L640.985 369.909C641.289 371.277 640.377 372.493 639.161 372.796L635.21 373.556C633.842 373.86 632.626 372.948 632.322 371.733L629.587 357.751L628.675 352.888L625.027 353.496L604.815 357.447L601.471 358.055L602.383 362.918L605.118 376.9C605.422 378.268 604.511 379.483 603.295 379.787L599.343 380.547C597.976 380.851 596.76 379.939 596.456 378.724L593.72 364.742L592.808 359.879L580.954 362.158L587.945 398.176L593.568 397.113L654.207 385.258Z" fill="#DADBE0"></path>
								<path d="M654.207 385.258L648.128 354.255L647.216 349.24L637.337 351.064L638.249 355.927L640.985 369.909C641.289 371.277 640.377 372.493 639.161 372.796L635.21 373.556C633.842 373.86 632.626 372.948 632.322 371.733L629.587 357.751L628.675 352.888L625.027 353.496L604.815 357.447L601.471 358.055L602.383 362.918L605.118 376.9C605.422 378.268 604.511 379.483 603.295 379.787L599.343 380.547C597.976 380.851 596.76 379.939 596.456 378.724L593.72 364.742L592.808 359.879L580.954 362.158L587.945 398.176L593.568 397.113L654.207 385.258Z" fill="black" opacity="0.1"></path>
								<path d="M654.207 385.258L593.568 397.113L587.489 366.109L593.72 364.894L596.456 378.875C596.76 380.243 597.976 381.003 599.343 380.851L603.295 380.091C604.663 379.787 605.422 378.571 605.118 377.204L602.383 363.374L606.03 362.614L626.243 358.663L629.739 358.055L632.474 372.037C632.778 373.404 633.994 374.164 635.362 373.86L639.313 373.1C640.681 372.796 641.441 371.581 641.289 370.365L638.553 356.383L648.28 354.559L652.231 374.468L654.207 385.258Z" fill="#DADBE0"></path>
								<path d="M605.118 377.051L602.383 363.222L601.471 358.358C601.167 357.143 599.951 356.231 598.735 356.535L594.784 357.295C593.568 357.599 592.656 358.814 592.96 360.03L593.872 364.893L596.608 378.875C596.912 380.243 598.127 381.003 599.495 380.851L603.447 380.091C604.51 379.635 605.27 378.419 605.118 377.051ZM640.985 370.061L638.249 356.079L637.337 351.216C637.033 350 635.817 349.088 634.602 349.392L630.65 350.152C629.434 350.456 628.523 351.672 628.827 353.039L629.738 357.903L632.474 371.884C632.778 373.252 633.994 374.012 635.361 373.708L639.313 372.948C640.529 372.644 641.289 371.428 640.985 370.061Z" fill="#0455A4" style="fill: #0455A4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455A4));"></path>
								<path d="M574.267 186.778C574.875 189.514 575.635 193.465 576.395 198.48C576.547 199.544 576.699 200.608 576.699 200.912C577.459 206.383 577.459 212.006 576.699 217.477C576.547 218.541 576.395 219.605 576.091 220.669C575.483 223.556 568.796 228.115 560.893 231.003C558.158 231.915 555.27 232.675 552.383 233.131C543.416 234.346 537.337 228.267 537.185 222.948C537.185 221.58 537.489 220.365 538.249 219.301C539.465 217.021 540.225 214.59 540.529 212.006C541.137 208.663 541.441 205.167 541.441 201.824C541.593 199.848 541.441 198.632 541.441 198.632L548.28 189.058L568.948 184.042C569.556 187.538 571.076 189.818 572.14 189.666C573.204 189.514 574.115 187.234 574.267 186.778Z" fill="#FFCB9D" style="fill: #FFCB9D; fill: var(--tblr-illustrations-skin, #FFCB9D);"></path>
								<path d="M574.267 186.778C574.875 189.513 575.635 193.465 576.395 198.48C576.547 199.544 576.699 200.608 576.699 200.912C577.459 206.383 577.459 212.006 576.699 217.477C575.331 217.325 573.811 217.021 572.596 216.413C571.228 215.653 569.86 214.741 568.796 213.526C567.732 212.31 566.821 210.79 566.213 209.27C565.757 208.358 565.301 207.295 564.997 206.231C561.349 208.51 557.398 210.182 553.143 211.094C549.039 212.006 544.784 212.31 540.529 211.854C541.137 208.51 541.441 205.015 541.441 201.672C541.593 199.696 541.441 198.48 541.441 198.48L548.28 188.906L568.948 183.89C569.556 187.386 571.076 189.665 572.14 189.513C573.204 189.362 574.115 187.234 574.267 186.778Z" fill="black" opacity="0.1"></path>
								<path d="M577.915 190.577C578.827 194.833 578.219 199.392 575.939 203.191C575.483 203.799 575.027 204.559 574.571 205.319C573.66 207.447 573.204 209.726 573.204 212.006C571.988 211.094 571.076 209.878 570.468 208.359C570.012 205.927 569.708 203.495 569.708 201.064V200.76C569.708 200.608 569.708 200.304 569.556 199.848C569.404 198.784 569.1 197.568 568.796 196.504V196.353C564.389 200.76 551.319 212.158 539.465 206.991C537.641 206.231 535.818 205.167 534.298 203.799C534.146 203.647 533.994 203.647 533.842 203.495C533.538 203.191 533.082 202.887 532.778 202.432L532.626 202.28C531.714 201.368 531.106 200.152 530.498 199.088L530.346 198.632C529.435 196.049 529.891 193.009 531.562 190.729C533.69 187.69 536.425 184.954 539.769 182.979C547.672 177.356 560.894 173.252 570.316 179.331C572.748 181.003 574.723 183.131 576.091 185.562C577.003 187.234 577.611 188.906 577.915 190.577Z" fill="#232B41" class="tblr-illustrations-not-found-c"></path>
								<path d="M603.903 337.386C603.599 338.45 603.447 339.514 603.599 340.577C603.599 344.529 605.726 347.568 608.918 348.176C613.021 348.936 617.276 345.289 618.644 339.969C618.796 339.362 618.948 338.754 618.948 338.298C619.404 333.738 617.277 329.939 613.781 329.331C609.526 328.571 605.27 332.219 603.903 337.386Z" fill="#FFCB9D" style="fill: #FFCB9D; fill: var(--tblr-illustrations-skin, #FFCB9D);"></path>
								<path d="M603.903 337.386C603.599 338.45 603.447 339.514 603.599 340.577L604.815 340.729C610.134 340.881 612.413 339.058 618.188 338.298H618.948C619.404 333.738 617.277 329.939 613.781 329.331C609.526 328.571 605.27 332.219 603.903 337.386Z" fill="black" opacity="0.1"></path>
								<path d="M466.973 191.641C466.517 190.577 465.909 189.666 465.301 188.906C462.869 185.866 459.374 184.65 456.486 186.17C452.839 188.146 451.775 193.617 453.903 198.632C454.207 199.088 454.511 199.696 454.815 200.152C457.246 203.951 461.349 205.775 464.541 203.951C468.036 202.128 469.1 196.504 466.973 191.641Z" fill="#FFCB9D" style="fill: #FFCB9D; fill: var(--tblr-illustrations-skin, #FFCB9D);"></path>
								<path d="M466.973 191.641C466.517 190.577 465.909 189.666 465.301 188.906C464.997 189.21 464.693 189.362 464.389 189.666C460.134 192.857 459.526 195.745 455.422 199.848C455.27 200 455.118 200.152 454.814 200.304C457.246 204.103 461.349 205.927 464.541 204.103C468.036 202.128 469.1 196.505 466.973 191.641Z" fill="black" opacity="0.1"></path>
								<path d="M584.45 326.292L582.93 335.107L565.605 433.587C563.629 434.347 561.806 435.107 559.83 435.866C557.55 426.748 555.575 417.325 553.751 407.143C550.255 386.778 548.128 366.262 547.52 345.745C542.809 344.529 537.945 343.313 533.082 342.097L519.86 338.906C519.708 344.377 519.556 350.304 519.86 356.535C520.012 362.31 520.468 367.781 521.076 372.948L513.021 373.86C506.334 353.04 499.496 332.219 492.809 311.246L509.678 312.614C516.821 313.222 523.812 313.83 530.803 314.59L584.45 326.292Z" fill="#0455A4" style="fill: #0455A4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455A4));"></path>
								<path d="M629.587 320.516C629.283 327.507 628.067 333.586 626.851 338.754L618.948 336.93L605.423 333.738L604.359 333.434L603.143 333.13L601.015 332.675L598.584 332.067C597.216 331.763 595.696 331.307 594.024 331.003C598.484 323.628 601.332 315.393 602.383 306.839C602.383 306.839 604.207 292.401 599.647 280.091L599.344 279.179C597.672 275.228 595.24 271.428 592.353 268.237L591.593 267.477C591.289 272.796 590.833 277.507 590.529 281.763C589.617 292.097 588.249 300.912 587.489 306.687C585.97 317.933 584.298 327.659 582.93 334.954L530.65 314.437C530.499 312.918 529.283 299.696 529.283 298.176C529.131 295.592 528.523 288.602 527.763 281.155C527.003 273.708 526.395 265.805 526.091 261.094C524.571 260.942 523.204 260.942 521.532 260.638C516.061 260.03 510.742 259.118 505.423 257.903L501.775 256.991C497.672 255.775 493.568 254.255 489.617 252.431C483.842 249.848 478.371 246.504 473.508 242.705C470.012 239.969 466.821 236.93 463.933 233.586C460.731 230.078 457.688 226.427 454.815 222.644C452.231 219.149 449.951 215.653 447.824 212.006C451.927 208.51 455.271 205.623 457.398 203.799C462.109 199.544 464.237 197.568 468.188 195.289C470.316 194.073 472.444 193.009 474.723 192.249C475.939 196.96 477.611 201.672 479.739 206.079C484.298 215.653 492.505 227.659 506.79 234.346C508.006 234.954 509.222 235.41 510.438 235.866C513.021 236.778 515.605 237.538 518.34 238.146C520.924 238.602 523.508 239.058 526.091 239.21C533.69 239.665 540.529 239.817 546.456 239.817C567.885 239.817 578.979 237.538 578.979 237.538C578.979 237.538 588.097 235.562 592.657 239.21L593.112 239.513C597.672 243.161 601.927 247.112 606.03 251.368C607.094 252.583 608.158 253.799 609.222 255.167C612.869 259.726 616.061 264.589 618.796 269.757C621.38 274.772 623.508 279.939 625.179 285.106C625.483 286.018 625.787 286.93 626.091 287.994C627.915 294.225 628.675 299.088 628.827 300.456C629.131 302.583 629.435 305.319 629.587 308.662C629.739 312.158 629.739 316.261 629.587 320.516Z" fill="#DADBE0"></path>
								<path d="M565.149 237.842C562.261 240.882 558.614 242.857 554.511 243.617C554.359 243.617 554.055 243.617 553.903 243.769L543.872 239.21L565.149 237.842Z" fill="#FFCB9D" style="fill: #FFCB9D; fill: var(--tblr-illustrations-skin, #FFCB9D);"></path>
								<path d="M591.593 267.629C591.289 272.948 590.833 277.66 590.529 281.915C589.617 292.249 588.249 301.064 587.489 306.839C585.97 318.237 584.298 327.812 582.93 335.258L530.65 314.742C580.498 312.918 591.593 267.629 591.593 267.629ZM629.587 320.517C629.283 327.508 628.067 333.587 626.851 338.754L618.948 336.93L605.422 333.739L604.359 333.435L603.143 333.131L601.015 332.675L598.584 332.067C602.231 328.267 606.03 324.012 609.678 318.845C617.732 307.751 622.748 296.96 626.091 287.842C627.915 294.073 628.675 298.936 628.827 300.304C629.131 302.432 629.435 305.167 629.587 308.511C629.739 312.158 629.739 316.261 629.587 320.517Z" fill="black" opacity="0.1"></path>
								<path d="M628.827 300.608C624.875 297.568 621.684 293.617 619.708 288.906C615.909 280.699 615.605 272.492 618.796 269.757C620.924 273.708 623.356 278.571 625.331 284.65C627.307 290.729 628.371 296.201 628.827 300.608Z" fill="#232B41" class="tblr-illustrations-not-found-c"></path>
								<path d="M582.93 335.258L565.605 433.739C563.629 434.498 561.805 435.258 559.83 436.018C557.55 426.9 555.574 417.477 553.751 407.295C550.255 386.93 548.128 366.413 547.672 345.745L548.432 321.581L582.93 335.258Z" fill="black" opacity="0.1"></path>
								<path d="M204.967 389.21C203.751 390.425 202.231 391.185 200.559 391.793C196.152 392.857 190.225 386.778 184.906 378.723C192.201 375.532 200.711 378.723 204.055 386.018C204.359 387.082 204.815 388.146 204.967 389.21ZM286.881 380.091C281.866 387.538 276.243 392.857 272.14 391.793C270.316 391.185 268.644 390.122 267.125 388.754C269.556 381.155 277.763 377.052 285.362 379.483C285.818 379.787 286.426 379.939 286.881 380.091Z" fill="#232B41" class="tblr-illustrations-not-found-c"></path>
								<path d="M591.441 166.261C588.401 165.045 585.058 166.565 583.994 169.605C582.778 172.644 584.298 175.988 587.337 177.052C590.377 178.267 593.72 176.748 594.784 173.708C596 170.669 594.48 167.325 591.441 166.261ZM602.231 120.213L590.985 157.903L597.824 160.486L612.565 125.684L602.231 120.213Z" fill="#0455A4" style="fill: #0455A4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455A4));"></path>
								<path d="M654.207 385.258L593.568 397.113C594.936 396.657 634.602 384.195 652.079 374.164L654.207 385.258ZM565.149 237.842C562.261 240.882 558.614 242.857 554.511 243.617C554.359 243.617 554.055 243.617 553.903 243.769L543.872 239.21L565.149 237.842Z" fill="black" opacity="0.1"></path>
								<path d="M554.511 243.617L573.508 231.763L577.915 235.714L564.997 252.584L554.511 243.617ZM553.903 243.769L541.441 234.65L538.553 237.69L547.064 250.456L553.903 243.769Z" fill="#0455A4" style="fill: #0455A4; fill: var(--tblr-illustrations-primary, var(--tblr-primary, #0455A4));"></path>
								<path d="M553.903 243.769L541.441 234.65L538.553 237.69L547.064 250.456L553.903 243.769Z" fill="black" opacity="0.1"></path>
								<path d="M536.73 390.426V391.186H511.35V390.426C511.35 388.754 511.957 386.93 513.021 385.562H535.058C536.274 387.082 536.73 388.754 536.73 390.426Z" fill="black" opacity="0.22"></path>
								<path d="M571.988 454.407L571.684 452.887C571.836 453.343 571.836 453.799 571.988 454.407ZM548.887 450.76L568.34 448.632C568.34 448.632 569.1 443.617 566.061 441.793C563.021 439.969 551.927 446.048 548.887 450.76ZM506.334 394.529L524.115 386.474C524.115 386.474 523.204 381.459 519.708 380.699C516.213 379.939 507.854 389.058 506.334 394.529ZM233.69 544.377L213.933 542.097C213.933 542.097 213.173 536.93 216.365 535.106C219.556 533.283 230.498 539.665 233.69 544.377ZM262.869 544.377L243.112 542.097C243.112 542.097 242.353 536.93 245.544 535.106C248.736 533.283 259.678 539.665 262.869 544.377Z" fill="#232B41" class="tblr-illustrations-not-found-c"></path>
								<path d="M568.644 196.353C564.237 200.76 551.167 212.158 539.313 206.991C537.489 206.231 535.666 205.167 534.146 203.799C533.994 203.647 533.842 203.647 533.69 203.495C533.234 203.192 532.93 202.888 532.626 202.432L532.474 202.28C531.562 201.368 530.954 200.152 530.346 199.088C533.234 200.76 536.425 201.976 539.769 202.736C556.03 206.079 569.404 193.769 571.532 191.793L571.684 191.641C570.772 193.313 569.86 194.833 568.644 196.353Z" fill="black" opacity="0.5"></path>
								<path d="M219.86 293.769C225.939 294.681 242.961 295.745 249.192 284.65C250.103 282.979 250.863 281.003 251.319 279.179C251.319 279.027 251.471 278.875 251.471 278.723C251.623 278.267 251.623 277.66 251.623 277.204V277.052C251.775 275.836 251.623 274.468 251.319 273.252C250.103 276.292 248.28 279.179 246.152 281.611C235.362 293.921 217.733 292.097 214.845 291.945H214.693C216.213 292.553 218.037 293.313 219.86 293.769Z" fill="black" opacity="0.5"></path>
								<path d="M501.775 256.991C497.672 256.079 492.049 254.407 486.122 251.368C480.802 248.632 476.851 245.593 473.812 243.009C476.243 242.705 483.234 242.249 490.529 246.049C497.216 249.544 500.559 254.711 501.775 256.991Z" fill="#232B41" class="tblr-illustrations-not-found-c"></path>
							</svg>
							<h3 class="mt-3"><?php e__('No tickets were found!'); ?></h3>
							<a class="btn btn-primary" href="<?php echo url('support.tickets.create') ?>"><?php e__('Open Ticket') ?></a>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</section>