<?php $this->layout('layouts/main'); ?>
<?php if (recaptcha()->isEnabled('reply_ticket')) : ?>
	<?php $this->push('head'); ?>
		<?php echo recaptcha()->getScript(); ?>
	<?php $this->end(); ?>
<?php endif; ?>
<?php $this->push('scripts'); ?>
<script src="<?php echo $this->asset('/js/plugins/ckeditor/ckeditor.js') ?>"></script>
<script src="<?php echo $this->asset('/js/ckeditor5.js') ?>"></script>
<script src="<?php echo $this->asset('/js/support.js') ?>"></script>

<?php if (modules('ai')->isActive() && modules('ai')->settings('autoReply') == '1' && $ticket["statusID"] == '1'): ?>
	<script>
      // AI Reply Request
      $(document).ready(function() {
          $.ajax({
              url: '<?php echo url('ai.replyTicket', ['id' => $ticket["id"]]); ?>',
              type: 'POST',
              headers: {
                  'X-CSRF-TOKEN': '<?php echo csrf_token(); ?>',
              }
          }).then(function(response) {
              if (response.status) {
                  // Refresh page
                  window.location.reload();
              }
          })
      });
	</script>
<?php endif; ?>
<?php $this->end(); ?>

<section class="section support-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12 mb-2">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"url" => url('support.tickets.index'),
						"text" => t__('Support')
					],
					[
						"text" => t__('View')
					]
				]]) ?>
			</div>
			<div class="col-md-9">
				<?php _message(); ?>
				<div>
					<h1 class="h2 mb-3">
						<?php echo substr($ticket["title"], 0, 50); ?>
					</h1>
					
					<div id="messagesBox" class="mb-4" style="overflow: auto; max-height: 500px;">
						<?php if (count($ticket["messages"]) > 0): ?>
							<?php foreach ($ticket["messages"] as $message): ?>
								<div class="card mb-2">
									<div class="card-body">
										<div class="row">
											<div class="col-auto">
												<a href="<?php echo url('members.show', ['id' => $message["user"]["id"]]); ?>">
													<?php $this->insert('components/avatar', [
														'avatar' => $message["user"]["avatar"],
														'username' => $message["user"]["displayName"],
														'class' => 'avatar float-left'
													]); ?>
												</a>
											</div>
											<div class="col ps-2">
												<div class="row align-items-center">
													<div class="col">
														<a href="<?php echo url('members.show', ['id' => $message["user"]["id"]]); ?>">
															<span class="h4">
																<?php echo $message["user"]["displayName"]; ?>
															</span>
														</a>
													</div>
													<div class="col-auto">
														<span class="small">
															<?php echo carbon($message["creationDate"])->intlFormat(); ?>
														</span>
													</div>
												</div>
												<div class="message-content">
													<?php echo $message["content"]; ?>
												</div>
											</div>
										</div>
									</div>
								</div>
							<?php endforeach; ?>
						<?php endif; ?>
					</div>
					
					<h2 class="h3 mb-2"><?php e__('Leave a Reply') ?></h2>
					<?php if ($ticket["statusID"] != 4): ?>
						<form data-toggle="form-submit-with-loader" action="<?php echo url('support.tickets.reply', ['id' => $ticket["id"]]) ?>" method="POST" class="needs-validation" novalidate="">
							<?php _csrf(); ?>
							<textarea
								id="ckeditor"
								name="message"
								placeholder="<?php e__('Write your message...') ?>"
								class="form-control"
								rows="6"
								data-upload="<?php echo url('support.tickets.upload') ?>"
								data-csrf="<?php echo csrf_token(); ?>"><?php _old('message') ?></textarea>
							<?php if (recaptcha()->isEnabled('reply_ticket')) : ?>
								<div class="mt-3 d-flex justify-content-end">
									<?php echo recaptcha()->getHTML() ?>
								</div>
							<?php endif; ?>
							<div class="d-flex justify-content-end">
								<button type="submit" class="btn btn-primary mt-3"><?php e__('Send') ?></button>
							</div>
						</form>
					<?php else: ?>
						<?php $this->insert('components/alert', ['type' => 'error', 'message' => t__("The ticket is closed. You can't send a message.")]); ?>
					<?php endif; ?>
				</div>
			</div>
			<div class="col-md-3">
				<div class="card">
					<div class="card-header">
						<h2 class="card-title fs-100">
							<?php e__('Details') ?>
						</h2>
					</div>
					<div class="card-body">
						<div class="mb-3">
							<label class="form-label mb-0"><?php e__('Category') ?>:</label>
							<div>
								<?php echo $ticket["categoryName"]; ?>
							</div>
						</div>
						<div class="mb-3">
							<label class="form-label mb-0"><?php e__('Status') ?>:</label>
							<div>
								<?php if ($ticket["statusID"] == 1): ?>
									<span class="badge text-white bg-info"><?php e__('Open') ?></span>
								<?php elseif ($ticket["statusID"] == 2): ?>
									<span class="badge text-white bg-success"><?php e__('Answered') ?></span>
								<?php elseif ($ticket["statusID"] == 3): ?>
									<span class="badge text-white bg-warning"><?php e__('User-Reply') ?></span>
								<?php elseif ($ticket["statusID"] == 4): ?>
									<span class="badge text-white bg-danger"><?php e__('Closed') ?></span>
								<?php else: ?>
									<span class="badge text-white bg-danger"><?php e__('Error!') ?></span>
								<?php endif; ?>
							</div>
						</div>
						<div class="mb-3">
							<label class="form-label mb-0"><?php e__('Date') ?>:</label>
							<div>
								<?php echo carbon($ticket["creationDate"])->intlFormat(); ?>
							</div>
						</div>
						<?php foreach ($ticket["fields"] as $field): ?>
							<div class="mb-3">
								<label class="form-label mb-0"><?php echo $field["field"] ?>:</label>
								<div>
									<?php echo $field["value"] ?>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>