<?php $this->layout('layouts/main'); ?>

<?php $this->push('scripts'); ?>
<script>
	$(document).ready(function() {
		$.ajax({
			url: '<?php echo url('email.verification.send'); ?>',
			type: 'POST',
			headers: {
				'X-CSRF-TOKEN': '<?php echo csrf_token(); ?>',
			}
		});
	});
</script>
<?php $this->end(); ?>

<section class="section support-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Email Verification')
					]
				]]) ?>
			</div>
			<div class="col-md-12">
				<?php _message(); ?>
				<div class="card">
					<div class="card-header">
						<h2 class="card-title"><?php e__('Email Verification') ?></h2>
					</div>
					<div class="card-body text-center">
						<p class="mt-5 mb-3">
							<?php e__('A verification email has been sent to <strong>%email%</strong>.', ['%email%' => auth()->user()->email()]) ?>
						</p>
						<p class="mb-5">
							<?php e__('Please check your email and click the verification link to confirm your email address. If you don’t see it, check your spam folder.') ?>
						</p>
					</div>
				</div>
				<form data-toggle="form-submit-with-loader" action="<?php echo url('email.verification.send-again') ?>" method="post" class="mt-4 text-center">
					<?php _csrf(); ?>
					<?php e__("Didn't receive the email?") ?>
					<button type="submit" class="btn-link px-0"><?php e__('Send Again') ?></button>
				</form>
			</div>
		</div>
	</div>
</section>