<?php $this->layout('layouts/main') ?>

<section class="section page-section">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php $this->insert('components/breadcrumb', ['items' => [
					[
						"text" => t__('Vote')
					]
				]]) ?>
			</div>
			<div class="col-md-12">
				<div class="col-md-12">
					<div class="card mb-4">
						<div class="card-header">
							<h4 class="card-title"><?php e__('Vote') ?></h4>
						</div>
						<?php if (modules('vote')->settings('description') != ""): ?>
							<div class="card-body">
								<div class="ck-content">
									<?php echo modules('vote')->settings('description') ?>
								</div>
							</div>
						<?php endif; ?>
					</div>
					
					<?php if ($voteLinks): ?>
						<div class="row">
							<?php foreach ($voteLinks as $voteLink): ?>
								<div class="col-md-3">
									<a target="_blank" class="card p-3 text-center" href="<?php echo $voteLink["link"]; ?>">
										<div>
											<?php echo $voteLink["name"]; ?>
											<i class="shi-external-link" style="margin-top: -5px;"></i>
										</div>
									</a>
								</div>
							<?php endforeach; ?>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</section>