<footer class="footer pt-5 pt-md-6">
	<div class="container pt-3 pt-md-0">
		<div class="row mb-4">
			<div class="col-md-5 mb-3">
				<div class="d-sm-flex justify-content-between">
					<div class="widget pb-1 mb-4">
						<h4 class="widget-title"><?php e__('About') ?></h4>
						<div class="text-muted mb-2 ck-content">
							<?php if (settings("about") == ''): ?>
								<?php e__('You can edit this text from the Dashboard.') ?>
							<?php else: ?>
								<?php echo settings("about"); ?>
							<?php endif; ?>
						</div>
						<div class="d-flex gap-1 mt-3">
							<?php if (count($languages) > 1): ?>
								<div class="btn-group dropdown dropup">
									<button class="btn btn-light border-input dropdown-toggle" type="button" id="languageMenu" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
										<?php echo $languages[array_search($lang, array_column($languages, 'code'))]["name"]; ?>
									</button>
									<ul class="dropdown-menu" aria-labelledby="languageMenu">
										<?php foreach ($languages as $language): ?>
											<a class="dropdown-item <?php echo ($language["code"] == $lang) ? "active" : null; ?>" href="?lang=<?php echo $language["code"] ?>">
												<?php echo $language["name"] ?>
											</a>
										<?php endforeach; ?>
									</ul>
								</div>
							<?php endif; ?>
							
							<?php if (!modules('tebex_store')->isActive() && count(money()->getCurrencies()) > 1 && modules('store')->settings('isCreditRequiredOnPurchase') == 0): ?>
								<div class="btn-group dropdown dropup">
									<button class="btn btn-light border-input select-menu dropdown-toggle" type="button" id="currencyMenu" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
										<?php echo money()->getCurrency()->getLabel(); ?>
									</button>
									<ul class="dropdown-menu" aria-labelledby="currencyMenu">
										<?php foreach (money()->getCurrencies() as $currencyItem): ?>
											<a class="dropdown-item <?php _active($currencyItem->getCode() == money()->getCurrency()->getCode()); ?>" href="?currency=<?php echo $currencyItem->getCode() ?>">
												<?php echo $currencyItem->getLabel() ?>
											</a>
										<?php endforeach; ?>
									</ul>
								</div>
							<?php endif; ?>
							
							<a href="?theme=dark" id="changeMode" class="btn btn-icon btn-light border-input hide-theme-dark">
								<i class="ti ti-moon"></i>
							</a>
							<a href="?theme=light" id="changeMode" class="btn btn-icon btn-light border-input hide-theme-light">
								<i class="ti ti-sun"></i>
							</a>
						</div>
					</div>
				</div>
			</div>
			<?php foreach ($footer as $footerBlock): ?>
				<div class="col-md-2">
					<div class="widget widget-light pb-1 mb-4">
						<h4 class="widget-title"><?php echo $footerBlock["title"]; ?></h4>
						<?php if (isset($footerBlock["children"])): ?>
							<ul>
								<?php foreach ($footerBlock["children"] as $footerItem): ?>
									<li>
										<a href="<?php echo $footerItem["url"]; ?>" class="widget-link" <?php echo (($footerItem["tab"] == 1) ? 'target="_blank"' : null); ?>>
											<?php if ($footerItem["icon"] != "none"): ?>
												<i class="<?php echo str_replace('fas fa-', 'far fa-', $footerItem["icon"]); ?> fs-3 me-1"></i>
											<?php endif; ?>
											<?php echo $footerItem["title"] ?>
										</a>
									</li>
								<?php endforeach; ?>
							</ul>
						<?php endif; ?>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
	</div>
	<div>
		<div class="container">
			<div class="row copyright-text">
				<div class="col-12 col-md text-center text-md-start mb-2 mb-md-0 opacity-50 me-1">
					<?php e__('All rights reserved. &copy; %year%', ['%year%' => date("Y")]) ?>
				</div>
				<div class="col-12 col-md-auto text-center text-md-start">
					<?php powered_by_leaderos(); ?>
				</div>
			</div>
		</div>
	</div>
</footer>