<?php if (!empty($announcements)) : ?>
	<ul class="broadcast">
		<?php foreach ($announcements as $announcement) : ?>
			<li class="broadcast-item">
				<a class="broadcast-link" href="<?php echo $announcement["url"]; ?>"><?php echo $announcement["title"]; ?></a>
			</li>
		<?php endforeach; ?>
	</ul>
<?php endif; ?>

<?php if (theme()->settings('header') == 'combo'): ?>
	<div class="header-banner">
		<div class="header-image">
			<img src="<?php echo theme()->settings("headerBackground"); ?>?cache=<?php echo settings('updatedAt') ?>">
		</div>
		<div class="header-banner-content">
			<div class="container">
				<div class="row g-0 w-100 align-items-center">
					<div class="col-md-4 d-flex justify-content-start">
						<a href="#!" data-toggle="copyip" data-clipboard-action="copy" data-clipboard-text="<?php echo settings('serverIP'); ?>" class="d-none d-lg-flex align-items-center text-uppercase no-underline">
							<div class="header-side-icon me-3">
								<svg height="800px" width="800px" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 53.626 53.626" xml:space="preserve">
									<g>
										<path d="M48.831,15.334c-7.083-11.637-17.753-3.541-17.753-3.541c-0.692,0.523-1.968,0.953-2.835,0.955
										l-2.858,0.002c-0.867,0.001-2.143-0.429-2.834-0.952c0,0-10.671-8.098-17.755,3.539C-2.286,26.97,0.568,39.639,0.568,39.639
										c0.5,3.102,2.148,5.172,5.258,4.912c3.101-0.259,9.832-8.354,9.832-8.354c0.556-0.667,1.721-1.212,2.586-1.212l17.134-0.003
										c0.866,0,2.03,0.545,2.585,1.212c0,0,6.732,8.095,9.838,8.354c3.106,0.26,4.758-1.812,5.255-4.912
										C53.055,39.636,55.914,26.969,48.831,15.334z M20.374,24.806H16.7v3.541c0,0-0.778,0.594-1.982,0.579
										c-1.202-0.018-1.746-0.648-1.746-0.648v-3.471h-3.47c0,0-0.433-0.444-0.549-1.613c-0.114-1.169,0.479-2.114,0.479-2.114h3.675
										v-3.674c0,0,0.756-0.405,1.843-0.374c1.088,0.034,1.885,0.443,1.885,0.443l-0.015,3.604h3.47c0,0,0.606,0.778,0.656,1.718
										C20.996,23.738,20.374,24.806,20.374,24.806z M37.226,28.842c-1.609,0-2.906-1.301-2.906-2.908c0-1.61,1.297-2.908,2.906-2.908
										c1.602,0,2.909,1.298,2.909,2.908C40.135,27.542,38.828,28.842,37.226,28.842z M37.226,20.841c-1.609,0-2.906-1.3-2.906-2.907
										c0-1.61,1.297-2.908,2.906-2.908c1.602,0,2.909,1.298,2.909,2.908C40.135,19.542,38.828,20.841,37.226,20.841z M44.468,25.136
										c-1.609,0-2.906-1.3-2.906-2.908c0-1.609,1.297-2.908,2.906-2.908c1.602,0,2.909,1.299,2.909,2.908
										C47.377,23.836,46.07,25.136,44.468,25.136z"/>
									</g>
								</svg>
							</div>
							<div>
								<div style="color: #bbb;">
									<?php if ($game_type == "minecraft"): ?>
										<span data-toggle="onlinetext" server-ip="<?php echo settings('serverIP'); ?>">-/-</span>
										<span><?php e__('players online') ?></span>
									<?php elseif ($game_type == "fivem"): ?>
										<span data-toggle="onlinetext_fivem" server-ip="<?php echo settings('serverIP'); ?>">-/-</span>
										<span><?php e__('players online') ?></span>
									<?php else: ?>
									  <?php e__('Play Now') ?>
									<?php endif; ?>
								</div>
								<div>
									<span class="text-white"><?php echo settings('serverIP'); ?></span>
								</div>
							</div>
						</a>
					</div>
					<div class="col-md-4 d-flex flex-column justify-content-center">
						<div class="zoom-hover text-center">
							<a href="<?php echo url('home') ?>">
								<img src="<?php echo theme()->settings("headerLogo"); ?>?cache=<?php echo settings('updatedAt') ?>" class="header-banner-logo" alt="<?php echo settings('serverName'); ?> Logo">
							</a>
						</div>
					</div>
					<div class="col-md-4 d-none d-lg-flex justify-content-end">
						<a href="<?php echo settings('discordUrl') == '' ? '#' : settings('discordUrl'); ?>" class="d-flex align-items-center text-end text-uppercase no-underline" target="_blank">
							<div>
								<?php if (theme()->settings('discordOnlineCount')): ?>
									<div style="color: #bbb;">
										<span data-toggle="discordonline" data-discord-id="<?php echo theme()->settings('discordServerID'); ?>">-/-</span>
										<span><?php e__('members online') ?></span>
									</div>
								<?php else: ?>
									<div style="color: #bbb;">
										<span><?php e__('Join Us') ?></span>
									</div>
								<?php endif; ?>
								<div>
									<span class="text-white"><?php e__('Discord Community') ?></span>
								</div>
							</div>
							<div class="header-side-icon ms-3">
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 127.14 96.36"><defs><style>.cls-1{fill:#fff;}</style></defs><g id="图层_2" data-name="图层 2"><g id="Discord_Logos" data-name="Discord Logos"><g id="Discord_Logo_-_Large_-_White" data-name="Discord Logo - Large - White"><path class="cls-1" d="M107.7,8.07A105.15,105.15,0,0,0,81.47,0a72.06,72.06,0,0,0-3.36,6.83A97.68,97.68,0,0,0,49,6.83,72.37,72.37,0,0,0,45.64,0,105.89,105.89,0,0,0,19.39,8.09C2.79,32.65-1.71,56.6.54,80.21h0A105.73,105.73,0,0,0,32.71,96.36,77.7,77.7,0,0,0,39.6,85.25a68.42,68.42,0,0,1-10.85-5.18c.91-.66,1.8-1.34,2.66-2a75.57,75.57,0,0,0,64.32,0c.87.71,1.76,1.39,2.66,2a68.68,68.68,0,0,1-10.87,5.19,77,77,0,0,0,6.89,11.1A105.25,105.25,0,0,0,126.6,80.22h0C129.24,52.84,122.09,29.11,107.7,8.07ZM42.45,65.69C36.18,65.69,31,60,31,53s5-12.74,11.43-12.74S54,46,53.89,53,48.84,65.69,42.45,65.69Zm42.24,0C78.41,65.69,73.25,60,73.25,53s5-12.74,11.44-12.74S96.23,46,96.12,53,91.08,65.69,84.69,65.69Z"/></g></g></g></svg>
							</div>
						</a>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php endif; ?>

<header class="navbar navbar-expand-md d-print-none" >
	<div class="container-xl">
		<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbar-menu" aria-controls="navbar-menu" aria-expanded="false" aria-label="Toggle navigation">
			<span class="navbar-toggler-icon"></span>
		</button>
		<?php if (theme()->settings('header') != 'combo'): ?>
			<h1 class="navbar-brand navbar-brand-autodark d-none-navbar-horizontal pe-0 pe-md-3">
				<a href="<?php echo url('home') ?>">
					<img src="<?php echo theme()->settings('headerLogo') ?>" alt="<?php echo settings('serverName') ?>" class="navbar-brand-image" style="height: 24px !important;">
				</a>
			</h1>
		<?php endif; ?>
		<div class="navbar-nav flex-row order-md-last">
			<?php if (auth()->check()): ?>
				<div class="nav-item dropdown no-hover-border">
					<a href="#" class="nav-link d-flex lh-1 text-reset p-0" data-bs-toggle="dropdown" aria-label="Open user menu">
						<?php $this->insert('components/avatar', [
							'avatar' => auth()->user()->avatar(),
							'username' => auth()->user()->displayName(),
							'class' => 'avatar avatar-sm'
						]); ?>
						<div class="d-none d-xl-block ps-2">
							<div class="fw-medium">
								<?php echo auth()->user()->displayName(); ?>
							</div>
							<div class="mt-1 small text-muted">
								<?php echo auth()->user()->primaryRoleName(); ?>
							</div>
						</div>
					</a>
					<div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
						<a href="<?php echo url('account.profile.index') ?>" class="dropdown-item">
							<i class="ti ti-user fs-3 me-2"></i>
							<?php e__('Profile') ?>
						</a>
						<?php if (modules('credit')->isActive()): ?>
							<a href="<?php echo url('credits.charge.index') ?>" class="dropdown-item">
								<i class="ti ti-wallet fs-3 me-2"></i>
								<?php e__('Balance') ?>: <span class="fw-bold ms-1"><?php echo money()->format(auth()->user()->credits()); ?></span> <i class="shi-plus-circle text-success"></i>
							</a>
						<?php endif; ?>
						<?php if (modules('store')->isActive()): ?>
							<a class="dropdown-item" href="<?php echo url('cart.index'); ?>">
								<i class="ti ti-shopping-cart fs-3 me-2"></i>
								<span><?php e__('Cart') ?> (<span class="shopping-cart-count"><?php echo $cartItemCount; ?></span>)</span>
							</a>
						<?php endif; ?>
						<?php if (modules('chest')->isActive()): ?>
							<a href="<?php echo url('chest.index') ?>" class="dropdown-item">
								<i class="ti ti-archive fs-3 me-2"></i>
								<?php e__('Chest') ?>
							</a>
						<?php endif; ?>
						<?php if (modules('bazaar')->isActive()): ?>
							<a href="<?php echo url('bazaar.manage.index') ?>" class="dropdown-item">
								<i class="ti ti-package fs-3 me-2"></i>
								<?php e__('Bazaar Storage') ?>
							</a>
						<?php endif; ?>
						<?php if (modules('gift')->isActive()): ?>
							<a href="<?php echo url('gifts.index') ?>" class="dropdown-item">
								<i class="ti ti-gift fs-3 me-2"></i>
								<?php e__('Gift') ?>
							</a>
						<?php endif; ?>
						<?php if (auth()->user()->isStaff()): ?>
							<a href="/dashboard" class="dropdown-item" rel="external">
								<i class="ti ti-dashboard fs-3 me-2"></i>
								<?php e__('Dashboard') ?>
							</a>
						<?php endif; ?>
						<form action="<?php echo url('auth.logout') ?>" method="post">
							<?php _csrf(); ?>
							<button type="submit" class="dropdown-item text-danger">
								<i class="ti ti-logout fs-3 me-2"></i>
								<?php e__('Logout') ?>
							</button>
						</form>
					</div>
				</div>
			<?php else: ?>
				<li class="nav-item no-hover-border">
					<a class="btn btn-transparent" href="<?php echo url('auth.login') ?>">
						<i class="ti ti-user me-2" style="font-size: 1.125rem;"></i>
						<?php e__('Login') ?>
					</a>
				</li>
				<?php if (settings('registrationStatus') == 1 && $login_provider == 'default'): ?>
					<li class="nav-item no-hover-border">
						<a class="btn btn-primary" href="<?php echo url('auth.register') ?>">
							<?php e__('Register') ?>
						</a>
					</li>
				<?php endif; ?>
			<?php endif; ?>
		</div>
		<div class="collapse navbar-collapse" id="navbar-menu">
			<div class="d-flex flex-column flex-md-row flex-fill align-items-stretch align-items-md-center">
				<ul class="navbar-nav">
					<?php foreach ($header as $headerItem) : ?>
						<?php if (isset($headerItem["children"])) : ?>
							<li class="nav-item dropdown <?php _active($headerItem["route"] == $route_type); ?>">
								<a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown" data-bs-auto-close="outside" role="button" aria-expanded="false">
									<span class="nav-link-icon d-md-none d-lg-inline-block">
										<i class="<?php echo str_replace('fas fa-', 'far fa-', $headerItem["icon"]); ?>" style="font-size: 1.125rem;"></i>
									</span>
									<span class="nav-link-title">
										<?php echo $headerItem["title"]; ?>
									</span>
								</a>
								<ul class="dropdown-menu">
									<?php foreach ($headerItem["children"] as $headerItemChildren) : ?>
										<li>
											<a class="dropdown-item" href="<?php echo $headerItemChildren["url"]; ?>" <?php echo (($headerItemChildren["tab"] == 1) ? 'target="_blank"' : null); ?>>
												<?php echo $headerItemChildren["title"]; ?>
											</a>
										</li>
									<?php endforeach; ?>
								</ul>
							</li>
						<?php else : ?>
							<li class="nav-item <?php _active($headerItem["route"] == $route_type); ?>">
								<a class="nav-link" href="<?php echo $headerItem["url"]; ?>" <?php echo (($headerItem["tab"] == 1) ? 'target="_blank"' : null); ?>>
									<span class="nav-link-icon d-md-none d-lg-inline-block">
										<i class="<?php echo str_replace('fas fa-', 'far fa-', $headerItem["icon"]); ?>" style="font-size: 1.125rem;"></i>
									</span>
									<span class="nav-link-title">
										<?php echo $headerItem["title"]; ?>
									</span>
								</a>
							</li>
						<?php endif; ?>
					<?php endforeach; ?>
				</ul>
			</div>
		</div>
	</div>
</header>