<?php
	namespace Main\Core;
	
	use Main\Services\UserService;
	
	class Auth {
		private static ?User $user = null;
		
		public function __construct()
		{
			if (isset($_SESSION['user'])) {
        self::$user = new User(
					$_SESSION['user']["id"],
					$_SESSION['user']["username"],
					$_SESSION['user']["realname"],
					$_SESSION['user']["email"],
					$_SESSION['user']["credit"],
					$_SESSION['user']["avatar"],
					$_SESSION['user']["creationDate"],
					$_SESSION['user']["isTfaVerified"],
					$_SESSION['user']["roles"],
					$_SESSION['user']["permissions"],
					[],
					$_SESSION['user']);
			}
		}
		
		public static function user(): ?User
		{
			return self::$user;
		}
		
		public static function check(): bool
		{
			return isset($_SESSION['user']);
		}
		
		public static function login($provider, $id, $remember = false)
		{
			// Check Bans
			$siteBannedStatus = db()->prepare("SELECT * FROM BannedAccounts WHERE accountID = ? AND categoryID = ? AND (expiryDate > ? OR expiryDate = ?)");
			$siteBannedStatus->execute(array($id, 1, datetime(), '1000-01-01 00:00:00'));
			$siteBannedStatus = $siteBannedStatus->fetch();
			if ($siteBannedStatus) {
				if ($provider == 'default') {
					return back()->flash('error', t__('Your account is banned!'));
				} else {
					return view('auth.failed', [
						'message' => t__('Your account is banned!')
					]);
				}
			}
			
			// Check Maintenance
			$permissions = UserService::getPermissions($id);
			if (settings("maintenanceStatus") == 1 && !UserService::isStaff($permissions)) {
				if ($provider == 'default') {
					return back()->flash('error', t__('The site is under maintenance!'));
				} else {
					return view('auth.failed', [
						'message' => t__('The site is under maintenance!')
					]);
				}
			}
			
			$isTfaVerified = null;
			if (modules('tfa')->isActive()) {
				$tfaKeys = db()->prepare("SELECT * FROM AccountTfaKeys WHERE accountID = ?");
				$tfaKeys->execute([$id]);
				$tfaKeys = $tfaKeys->fetch();
				if ($tfaKeys) {
					$isTfaVerified = 0;
				}
			}
			
			$loginToken = rand_token();
			$insertAccountSessions = db()->prepare("INSERT INTO AccountSessions (accountID, loginToken, useragent, isTfaVerified, creationIP, expiryDate, creationDate) VALUES (?, ?, ?, ?, ?, ?, ?)");
			$insertAccountSessions->execute(array($id, $loginToken, $_SERVER['HTTP_USER_AGENT'], $isTfaVerified, getIP(), createDuration(($remember ? 365 : 0.01666666666)), datetime()));
			
			if ($remember) {
				cookies()->set('rememberMe', $loginToken, 365 * 60 * 60 * 24);
			}
			session()->set("login", $loginToken);
			
			$redirect = session()->get('redirect');
			if ($redirect != null && is_redirectable($redirect)) {
				session()->remove('redirect');
				redirect($redirect);
			} else {
				redirect(url('account.profile.index'));
			}
		}
		
		public static function logout(): void
		{
			// Set the expiry date to now and end the session
			if (session()->has('login')) {
				$updateSession = db()->prepare("UPDATE AccountSessions SET expiryDate = ? WHERE loginToken = ?");
				$updateSession->execute([datetime(), session()->get('login')]);
			}
			
			cookies()->remove("rememberMe");
			unset($_SESSION['login']);
			unset($_SESSION['user']);
		}
	}