<?php
	
	namespace Main\Core;
	
	class Cache
	{
		private array $settings;
		
		public function __construct(array $settings = [])
		{
			$this->settings = $this->parseSettings($settings);
		}
		
		private function parseSettings(array $settings): array
		{
			$parsed_settings = [];
			foreach ($settings as $key => $value) {
				if (substr($key, 0, 6) === 'cache:') {
					$parsed_settings[substr($key, 6)] = $value;
				}
			}
			return $parsed_settings;
		}
		
		public function get(string $key, $default = null)
		{
			if (isset($this->settings[$key])) {
				return $this->settings[$key];
			}
			return $default;
		}
		
		public function set(string $key, $value): void
		{
			if (isset($this->settings[$key])) {
				$update = db()->prepare("UPDATE Settings SET value = ? WHERE name = ?");
				$update->execute([$value, 'cache:' . $key]);
			} else {
				$insert = db()->prepare("INSERT INTO Settings (name, value) VALUES (?, ?)");
				$insert->execute(['cache:' . $key, $value]);
			}
			
			$this->settings[$key] = $value;
		}
		
		public function purge(string $key): void
		{
			$this->settings[$key] = "";
			
			$purge = db()->prepare("UPDATE Settings SET value = '' WHERE name = ?");
			$purge->execute(['cache:' . $key]);
		}
		
		public function delete(string $key): void
		{
			unset($this->settings[$key]);
			
			$delete = db()->prepare("DELETE FROM Settings WHERE name = ?");
			$delete->execute(['cache:' . $key]);
		}
	}