<?php
	namespace Main\Core;
	
	class Cookie {
		private static array $cookie = [];
		
		public function __construct()
		{
			self::$cookie = $_COOKIE;
		}
		
		public static function get($name)
		{
			return self::$cookie[$name] ?? null;
		}
		
		public static function has($name): bool
		{
			return self::$cookie[$name] ?? false;
		}
		
		public static function set($name, $value, $expire = 0, $path = '/', $domain = '', $secure = false, $httponly = false): void
		{
			setcookie($name, $value, time() + $expire, $path, $domain, $secure, $httponly);
		}
		
		public static function remove($name): void
		{
			unset($_COOKIE[$name]);
			setcookie($name, '', -1, '/');
		}
	}