<?php
	namespace Main\Core;
	
	class Currency
	{
		private string $code;
		private string $symbol;
		private float $rate;
		private ?string $suffix;
		private ?string $prefix;
		private ?string $label;
		
		public function __construct(string $code, string $symbol, float $rate, ?string $suffix, ?string $prefix, ?string $label)
		{
			$this->code = $code;
			$this->symbol = $symbol;
			$this->rate = $rate;
			$this->suffix = $suffix;
			$this->prefix = $prefix;
			$this->label = $label;
		}
		
		public function getCode(): string
		{
			return $this->code;
		}
		
		public function getSymbol(): string
		{
			return $this->symbol;
		}
		
		public function getRate(): float
		{
			return $this->rate;
		}
		
		public function getSuffix(): ?string
		{
			return $this->suffix;
		}
		
		public function getPrefix(): ?string
		{
			return $this->prefix;
		}
		
		public function getLabel(): ?string
		{
			return $this->label;
		}
	}