<?php
	namespace Main\Core;
	
	use PDO;
	
	class Forum {
		private ForumUser $user;
		
		public function __construct()
		{
			$this->user = new ForumUser($this->loadUserPermissions());
		}
		
		private function loadUserPermissions(): array
		{
			$roleIDs = [0];
			if (auth()->check()) {
				if (auth()->user()->can('MANAGE_FORUM')) {
					return ['*' => '*'];
				}
				
				$roleIDs = array_merge($roleIDs, array_column(auth()->user()->roles(), 'id'));
			}
			
			// Get permissions for roles
			$permissions = [];
			$unorganizedPermissions = [];
			foreach ($roleIDs as $roleID) {
				$forumPermissions = db()->prepare("SELECT FRP.categoryID, P.name FROM ForumRolePermissions FRP INNER JOIN ForumPermissions P ON FRP.permissionID = P.id WHERE FRP.roleID = ?");
				$forumPermissions->execute([$roleID]);
				$forumPermissions = $forumPermissions->fetchAll(PDO::FETCH_ASSOC);
				
				// Merge Arrays
				$unorganizedPermissions = array_merge($unorganizedPermissions, $forumPermissions);
			}
			
			// Organize permissions
			foreach ($unorganizedPermissions as $permission) {
				if (!isset($permissions[$permission['categoryID']])) {
					$permissions[$permission['categoryID']] = [];
				}
				if (!in_array($permission['name'], $permissions[$permission['categoryID']])) {
					$permissions[$permission['categoryID']][] = $permission['name'];
				}
			}
			
			return $permissions;
		}
		
		public function user(): ForumUser
		{
			return $this->user;
		}
	}