<?php
	namespace Main\Core;
	
	class ForumUser {
		private array $permissions;
		
		public function __construct(array $permissions)
		{
			$this->permissions = $permissions;
		}
		
		public function permissions(): array
		{
			return $this->permissions;
		}
		
		public function can($categoryID, $perm): bool
		{
			// Check if user has all permissions
			if (isset($this->permissions['*']) && $this->permissions['*'] == '*') {
				return true;
			}
			
			// Check if user has MODERATE_FORUM permission
			if (isset($this->permissions[$categoryID]) && in_array("MODERATE_FORUM", $this->permissions[$categoryID])) {
				return true;
			}
			
			if (isset($this->permissions[$categoryID]) && in_array($perm, $this->permissions[$categoryID])) {
				return true;
			}
			
			return false;
		}
	}