<?php
	namespace Main\Core;
	
	class Module {
		
		private string $id;
		private string $slug;
		private string $name;
		private string $version;
		private bool $isActive;
		private array $settings;
		
		public function __construct(string $id, string $slug, string $name, string $version, bool $isActive, array $settings) {
			$this->id = $id;
			$this->slug = $slug;
			$this->name = $name;
			$this->version = $version;
			$this->isActive = $isActive;
      $this->settings = $settings;
		}
		
		public function id(): string {
			return $this->id;
		}
		
		public function slug(): string {
			return $this->slug;
		}
		
		public function name(): string {
			return $this->name;
		}
		
		public function version(): string {
			return $this->version;
		}
		
		public function isActive(): string {
			return $this->isActive;
		}
		
		public function settings($name) {
			return $this->settings[$name] ?? "";
		}
		
		public function updateSetting($key, $value): void {
			$this->settings[$key] = $value;
			
			$updateSettings = db()->prepare("UPDATE ModuleSettings SET value = ? WHERE name = ? AND moduleID = ?");
			$updateSettings->execute(array($value, $key, $this->id()));
		}
		
		public function updateSettings($settings): void {
			foreach ($settings as $key => $value) {
				$this->updateSetting($key, $value);
			}
		}
	}
