<?php
	namespace Main\Core;
	
	class Session {
		private static array $session = [];
		
		public function __construct()
		{
			self::$session = $_SESSION;
		}
		
		public static function get($name)
		{
			return self::$session[$name] ?? null;
		}
		
		public static function has($name): bool
		{
			return self::$session[$name] ?? false;
		}
		
		public static function set($name, $value): void
		{
			$_SESSION[$name] = $value;
		}
		
		public static function remove($name): void
		{
			if (isset($_SESSION[$name])) {
				unset($_SESSION[$name]);
			}
		}
	}