<?php
	namespace Main\Core;
	
	class Theme {
		
		private string $id;
		private string $name;
		private string $version;
		private string $thumbnail;
		private string $path;
		private string $realPath;
		private array $settings;
		private array $defaultSettings;
		
		public function __construct(string $id, array $settings) {
			$this->id = $id;
			$this->path = "/apps/main/app/views/themes/" . $this->id;
			$this->realPath = __ROOT__ . $this->path;
			$themeJson = $this->getThemeJson();
			$this->name = $themeJson['name'];
			$this->version = $themeJson['version'];
			$this->thumbnail = $themeJson['thumbnail'];
			$this->settings = $this->parseSettings($settings);
			$this->defaultSettings = $this->parseJsonSettings($themeJson['settingsCategories']);
		}
		
		public function id(): string {
			return $this->id;
		}
		
		public function name(): string {
			return $this->name;
		}
		
		public function version(): string {
			return $this->version;
		}
		
		public function thumbnail(): string {
			return $this->thumbnail;
		}
		
		public function path($path = ""): string {
			return $this->path . $path;
		}
		
		public function realPath($path = ""): string {
			return $this->realPath . $path;
		}
		
		public function settings($name): string {
			if (isset($this->settings[$name])) {
				return $this->settings[$name];
			} else if (isset($this->defaultSettings[$name])) {
				return $this->defaultSettings[$name];
			}
			
			return "";
		}
		
		private function getThemeJson(): array {
			return json_decode(
				file_get_contents($this->realPath . '/theme.json'),
				true
			);
		}
		
		private function parseSettings($settings): array {
			$parsedSettings = [];
			
			foreach($settings as $name => $value) {
				$name = explode(':', $name);
				$parsedSettings[$name[2]] = $value;
			}
			
			return $parsedSettings;
		}
		
		private function parseJsonSettings($settings): array {
			$parsedSettings = [];
			
			foreach($settings as $category) {
				foreach($category['settings'] as $name => $setting) {
					$parsedSettings[$name] = $setting['value'];
				}
			}
			
			return $parsedSettings;
		}
	}
